/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.GraphExplorer;

public class KeyToSelectionAdapter
extends KeyAdapter {
    private static final int KEY_INPUT_DELAY = 500;
    private final GraphExplorer explorer;
    private String matcher = "";
    private int prevEvent = 0;
    private int columns = 0;
    protected Pattern alphaNum;
    private TreeItem previous = null;
    private boolean foundPrev = false;

    public KeyToSelectionAdapter(GraphExplorer explorer) {
        assert (explorer != null);
        this.explorer = explorer;
        this.alphaNum = Pattern.compile("\\p{Alnum}");
    }

    public void keyPressed(KeyEvent e) {
        if (this.explorer.isDisposed()) {
            return;
        }
        if (!this.alphaNum.matcher(Character.toString(e.character)).matches()) {
            return;
        }
        if (e.time - this.prevEvent > 500) {
            this.matcher = "";
        }
        this.prevEvent = e.time;
        this.matcher = this.matcher = String.valueOf(this.matcher) + Character.toString(e.character);
        TreeItem item = null;
        Tree tree = (Tree)this.explorer.getControl();
        this.columns = tree.getColumnCount();
        TreeItem[] selected = tree.getSelection();
        item = this.find(tree, selected);
        if (item == null && this.matcher.length() > 1) {
            this.matcher = this.matcher.substring(this.matcher.length() - 1);
            item = this.find(tree, selected);
        }
        if (item != null) {
            tree.select(item);
            tree.showItem(item);
        }
        e.doit = false;
    }

    private TreeItem find(Tree tree, TreeItem[] selected) {
        TreeItem item = null;
        TreeItem[] items = tree.getItems();
        if (selected.length == 0) {
            this.previous = null;
            this.foundPrev = true;
            item = this.findItem(items, 0);
        } else {
            this.previous = selected[0];
            this.foundPrev = false;
            item = this.findItem(items, 0);
            if (item == null) {
                this.previous = null;
                this.foundPrev = true;
                item = this.findItem(items, 0);
            }
        }
        return item;
    }

    private TreeItem findItem(TreeItem[] items, int depth) {
        int i = 0;
        while (i < items.length) {
            TreeItem childItem;
            TreeItem item = items[i];
            if (item != this.previous) {
                if (this.foundPrev && this.matches(item, depth, this.columns, this.matcher)) {
                    return item;
                }
            } else {
                this.foundPrev = true;
            }
            if ((childItem = this.findItem(item.getItems(), depth + 1)) != null) {
                return childItem;
            }
            ++i;
        }
        return null;
    }

    protected boolean matches(TreeItem item, int depth, int columns, String matcher) {
        int c = 0;
        while (c < columns) {
            if (this.matchesColumn(item, c, matcher)) {
                return true;
            }
            ++c;
        }
        return false;
    }

    protected boolean matchesColumn(TreeItem item, int column, String matcher) {
        String text = item.getText(column);
        return text.toLowerCase().startsWith(matcher);
    }
}

