/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IDisposable;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.swt.ContextMenuInitializer;
import org.simantics.browsing.ui.swt.DefaultExplorerSelectionListener;
import org.simantics.browsing.ui.swt.DefaultKeyListener;
import org.simantics.browsing.ui.swt.DefaultMouseListener;
import org.simantics.browsing.ui.swt.DefaultSelectionDataResolver;
import org.simantics.browsing.ui.swt.GraphExplorerFactory;
import org.simantics.browsing.ui.swt.IContextMenuInitializer;
import org.simantics.browsing.ui.swt.ViewArgumentUtils;
import org.simantics.db.Session;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.dnd.BasicDragSource;
import org.simantics.ui.dnd.SessionContainer;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.datastructures.Function;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.HintTracker;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintTracker;
import org.simantics.utils.ui.LayoutUtils;

public abstract class GraphExplorerViewBase
extends ViewPart {
    protected LocalResourceManager resourceManager;
    protected ISelectionListener workbenchSelectionListener;
    protected Composite parent;
    protected GraphExplorer explorer;
    protected IMenuManager menuManager;
    private Map<String, String> args;
    private ISessionContextProvider contextProvider;
    private ISessionContext sessionContext;
    private Object dragSource;
    protected IMemento memento;
    private IHintTracker sessionContextTracker = new SessionContextProjectTracker();
    private SessionContextInputSource inputSource = new SessionContextProjectSource();
    private DisposeState disposeState = DisposeState.Alive;
    protected ISessionContextChangedListener contextChangeListener = new ISessionContextChangedListener(){

        public void sessionContextChanged(SessionContextChangedEvent event) {
            GraphExplorerViewBase.this.sessionContext = event.getNewValue();
            GraphExplorerViewBase.this.sessionContextTracker.track((IHintContext)GraphExplorerViewBase.this.sessionContext);
        }
    };
    private Object currentInput;

    protected void setSessionContextTracker(IHintTracker tracker) {
        this.sessionContextTracker = tracker;
    }

    protected void setInputSource(SessionContextInputSource source) {
        this.inputSource = source;
    }

    protected SessionContextInputSource getInputSource() {
        return this.inputSource;
    }

    protected Map<String, String> getViewArguments() {
        return this.args;
    }

    protected DisposeState getDisposeState() {
        return this.disposeState;
    }

    public ISessionContext getSessionContext() {
        return this.sessionContext;
    }

    public ISessionContextProvider getSessionContextProvider() {
        return this.contextProvider;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()));
        this.contextProvider = SimanticsUI.getSessionContextProvider((Object)this.getViewSite().getWorkbenchWindow());
        this.createControls(parent);
        this.attachToSession();
    }

    public void dispose() {
        this.disposeState = DisposeState.Disposing;
        try {
            if (this.contextProvider != null) {
                this.contextProvider.removeContextChangedListener(this.contextChangeListener);
                this.contextProvider = null;
            }
            this.sessionContextTracker.untrack();
            this.resourceManager.dispose();
            this.resourceManager = null;
            this.args = null;
            this.explorer = null;
            this.sessionContext = null;
            this.dragSource = null;
            this.parent = null;
            super.dispose();
        }
        finally {
            this.disposeState = DisposeState.Disposed;
        }
    }

    public void setFocus() {
        if (this.explorer != null && !this.explorer.isDisposed()) {
            this.explorer.setFocus();
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.args = ViewArgumentUtils.parseViewArguments((IViewPart)this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.args = ViewArgumentUtils.parseViewArguments((IViewPart)this);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.memento != null) {
            memento.putMemento(this.memento);
        }
    }

    protected void setWorkbenchListeners() {
        if (this.workbenchSelectionListener == null) {
            ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
            this.getSite().setSelectionProvider(selectionProvider);
            this.workbenchSelectionListener = new DefaultExplorerSelectionListener((IWorkbenchPart)this, this.explorer);
            this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.workbenchSelectionListener);
        }
    }

    protected void removeWorkbenchListeners() {
        if (this.workbenchSelectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.workbenchSelectionListener);
            if (this.workbenchSelectionListener instanceof IDisposable) {
                ((IDisposable)this.workbenchSelectionListener).dispose();
            }
            this.workbenchSelectionListener = null;
            this.getSite().setSelectionProvider(null);
        }
    }

    protected final void attachToSession() {
        this.contextProvider.addContextChangedListener(this.contextChangeListener);
        this.sessionContext = this.contextProvider.getSessionContext();
        this.sessionContextTracker.track((IHintContext)this.sessionContext);
    }

    protected Column[] getColumns() {
        return null;
    }

    protected void createControls(Composite parent) {
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1, (boolean)false));
        this.explorer = this.createExplorerControl(parent);
        ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
        Control control = (Control)this.explorer.getControl();
        Column[] columns = this.getColumns();
        if (columns != null) {
            this.explorer.setColumns(columns);
        }
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
        IContextMenuInitializer cmi = this.getContextMenuInitializer();
        if (cmi != null) {
            this.menuManager = cmi.createContextMenu(control, selectionProvider, (IWorkbenchSite)this.getSite());
        }
        this.dragSource = this.createDragSource(this.explorer);
        this.addListeners(this.explorer, this.menuManager);
    }

    protected IContextMenuInitializer getContextMenuInitializer() {
        String contextMenuId = this.getContextMenuId();
        if (contextMenuId != null) {
            return new ContextMenuInitializer(contextMenuId);
        }
        return null;
    }

    protected String getContextMenuId() {
        return null;
    }

    protected int getStyle() {
        return 2;
    }

    protected GraphExplorer createExplorerControl(Composite parent) {
        return GraphExplorerFactory.getInstance().selectionDataResolver(new DefaultSelectionDataResolver()).create(parent, this.getStyle());
    }

    protected Object createDragSource(GraphExplorer explorer) {
        ISelectionProvider selectionProvider = (ISelectionProvider)explorer.getAdapter(ISelectionProvider.class);
        Control control = (Control)explorer.getControl();
        return new BasicDragSource(selectionProvider, control, null);
    }

    protected void setupDragSource(Session session) {
        if (this.dragSource instanceof SessionContainer) {
            ((SessionContainer)this.dragSource).setSession(session);
        }
    }

    protected void addListeners(GraphExplorer explorer, IMenuManager menuManager) {
        this.addSelectionInputListeners(explorer, menuManager);
    }

    protected void addSelectionInputListeners(GraphExplorer explorer, IMenuManager menuManager) {
        explorer.addListener((Object)new DefaultKeyListener(this.contextProvider, explorer, new Function<String[]>(){

            public String[] execute(Object ... obj) {
                return new String[]{GraphExplorerViewBase.this.getEditingColumn((NodeContext)obj[0])};
            }
        }));
        explorer.addListener((Object)new DefaultMouseListener(explorer));
    }

    protected String getEditingColumn(NodeContext context) {
        return "single";
    }

    protected void initializeExplorer(GraphExplorer explorer, ISessionContext context) {
        this.setupDragSource(context != null ? context.getSession() : null);
    }

    protected boolean isImportantInput(Object previousInput, Object input) {
        return !Objects.equals(previousInput, input);
    }

    protected final boolean applySessionContext(ISessionContext context) {
        if (this.disposeState != DisposeState.Alive) {
            return false;
        }
        this.sessionContext = context;
        Object input = this.inputSource.get(context);
        if (!this.isImportantInput(this.currentInput, input)) {
            return false;
        }
        this.initializeExplorer(this.explorer, context);
        this.explorer.setRoot(input);
        this.currentInput = input;
        this.sessionContextTracker.track((IHintContext)this.sessionContext);
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (GraphExplorer.class == adapter) {
            return (T)this.explorer;
        }
        if (ISessionContextProvider.class == adapter) {
            return (T)this.getSessionContextProvider();
        }
        if (IPropertyPage.class == adapter) {
            return (T)this.getPropertyPage();
        }
        return (T)super.getAdapter(adapter);
    }

    protected IPropertyPage getPropertyPage() {
        return null;
    }

    public class SessionContextProjectSource
    implements SessionContextInputSource {
        public Object get(ISessionContext ctx) {
            if (ctx == null) {
                return GraphExplorer.EMPTY_INPUT;
            }
            String inputId = GraphExplorerViewBase.this.getViewArguments().get("input");
            if (inputId != null) {
                try {
                    return ctx.getSession().syncRequest(Queries.resource((String)inputId));
                }
                catch (DatabaseException databaseException) {}
            }
            Object input = GraphExplorer.EMPTY_INPUT;
            IProject project2 = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
            if (project2 != null) {
                input = project2.get();
            }
            return input;
        }

        public IWorkbenchPart getProvider() {
            return null;
        }
    }

    public class SessionContextProjectTracker
    extends HintTracker {
        public SessionContextProjectTracker() {
            HintListenerAdapter activeProjectListener = new HintListenerAdapter(){

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    GraphExplorerViewBase.this.applySessionContext(GraphExplorerViewBase.this.getSessionContext());
                }
            };
            this.addKeyHintListener(ProjectKeys.KEY_PROJECT, (IHintListener)activeProjectListener);
        }
    }
}

