/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Bundle;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.SelectionDataResolver;
import org.simantics.browsing.ui.SelectionFilter;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.browsing.ui.swt.GraphExplorerImpl;
import org.simantics.browsing.ui.swt.GraphExplorerImpl2;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.ReadInterface;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ExceptionUtils;

public class GraphExplorerFactory {
    private int maxChildrenShown = 1000;
    private SelectionDataResolver selectionDataResolver;
    private SelectionFilter selectionFilter;
    private IServiceLocator serviceLocator;
    private BiFunction<GraphExplorer, Object[], Object[]> selectionTransformation = new BiFunction<GraphExplorer, Object[], Object[]>(){

        private Resource getModel(Object object) {
            if (object instanceof NodeContext) {
                NodeContext context = (NodeContext)object;
                Object input = context.getConstant(BuiltinKeys.INPUT);
                if (input instanceof Resource) {
                    final Resource inputResource = (Resource)input;
                    try {
                        return (Resource)Simantics.getSession().sync((ReadInterface)new UniqueRead<Resource>(){

                            public Resource perform(ReadGraph graph) throws DatabaseException {
                                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                                return (Resource)graph.sync((ReadInterface)new PossibleTypedParent(inputResource, SIMU.Model));
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                } else if (input instanceof Variable) {
                    final Variable inputVariable = (Variable)input;
                    try {
                        return (Resource)Simantics.getSession().sync((ReadInterface)new UniqueRead<Resource>(){

                            public Resource perform(ReadGraph graph) throws DatabaseException {
                                return Variables.getModel((ReadGraph)graph, (Variable)inputVariable);
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
            }
            return null;
        }

        @Override
        public Object[] apply(GraphExplorer explorer, Object[] objects) {
            Object[] result = new Object[objects.length];
            int i = 0;
            while (i < objects.length) {
                AdaptableHintContext context = new AdaptableHintContext(new IHintContext.Key[]{SelectionHints.KEY_MAIN});
                context.setHint(SelectionHints.KEY_MAIN, objects[i]);
                Resource model = this.getModel(objects[i]);
                if (model != null) {
                    context.setHint(SelectionHints.KEY_MODEL, (Object)model);
                }
                result[i] = context;
                ++i;
            }
            return result;
        }
    };

    public static GraphExplorerFactory getInstance() {
        return new GraphExplorerFactory();
    }

    public GraphExplorerFactory maxChildrenShown(int n) {
        this.maxChildrenShown = n;
        return this;
    }

    public GraphExplorerFactory selectionTransformation(BiFunction<GraphExplorer, Object[], Object[]> transformation) {
        this.selectionTransformation = transformation;
        return this;
    }

    public GraphExplorerFactory selectionDataResolver(SelectionDataResolver r) {
        this.selectionDataResolver = r;
        return this;
    }

    public GraphExplorerFactory setSelectionFilter(SelectionFilter filter) {
        this.selectionFilter = filter;
        return this;
    }

    public GraphExplorerFactory setServiceLocator(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
        return this;
    }

    public GraphExplorer create(Composite parent) {
        return this.create(parent, 0);
    }

    public GraphExplorer create(Composite parent, int style) {
        return this.createWithStyle(parent, style | 0x10000000);
    }

    public GraphExplorer createWithStyle(Composite parent, int style) {
        GraphExplorerWithMaxChildren explorer = new GraphExplorerWithMaxChildren(parent, style, this.maxChildrenShown);
        explorer.setSelectionDataResolver(this.selectionDataResolver);
        explorer.setSelectionFilter(this.selectionFilter);
        explorer.setSelectionTransformation(this.selectionTransformation);
        explorer.setServiceLocator(this.serviceLocator);
        return explorer;
    }

    public GraphExplorer create2(Composite parent, int style) {
        GraphExplorerImpl2 explorer = new GraphExplorerImpl2(parent, style);
        explorer.setSelectionDataResolver(this.selectionDataResolver);
        explorer.setSelectionFilter(this.selectionFilter);
        explorer.setSelectionTransformation(this.selectionTransformation);
        explorer.setServiceLocator(this.serviceLocator);
        return explorer;
    }

    public GraphExplorer create3(Composite parent, int style) {
        try {
            Bundle bundle = Platform.getBundle((String)"org.simantics.browsing.ui.nattable");
            Class clazz = bundle.loadClass("org.simantics.browsing.ui.nattable.NatTableGraphExplorer");
            GraphExplorer explorer = (GraphExplorer)clazz.getConstructor(Composite.class, Integer.TYPE).newInstance(parent, style);
            explorer.setSelectionDataResolver(this.selectionDataResolver);
            explorer.setSelectionFilter(this.selectionFilter);
            explorer.setSelectionTransformation(this.selectionTransformation);
            Method m = clazz.getMethod("setServiceLocator", IServiceLocator.class);
            m.invoke((Object)explorer, this.serviceLocator);
            return explorer;
        }
        catch (Throwable t) {
            ExceptionUtils.logAndShowError((Throwable)t);
            return null;
        }
    }

    private static class GraphExplorerWithMaxChildren
    extends GraphExplorerImpl {
        GraphExplorerWithMaxChildren(Composite parent, int style, int maxChildrenShown) {
            super(parent, style);
            this.setMaxChildren(maxChildrenShown);
        }
    }
}

