/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.processors.FilterSelectionRequestQueryProcessor;
import org.simantics.browsing.ui.common.views.IFilterArea;
import org.simantics.browsing.ui.common.views.IFilterAreaProvider;
import org.simantics.browsing.ui.common.views.IFocusable;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ISelectionUtils;

public class FilterArea
extends Composite
implements IFocusable,
IFilterArea,
IFilterAreaProvider {
    protected static final Integer FILTER_DELAY = 500;
    private final LocalResourceManager resourceManager;
    protected GraphExplorer explorer;
    protected FilterSelectionRequestQueryProcessor queryProcessor;
    private Text filterText;
    private NodeContext currentContext;
    protected Control clearButtonControl;
    private Map<NodeContext, AtomicInteger> modCount = new HashMap<NodeContext, AtomicInteger>();

    public FilterArea(GraphExplorer explorer, FilterSelectionRequestQueryProcessor queryProcessor, Composite parent, int style) {
        super(parent, style | 0x800);
        this.explorer = explorer;
        this.queryProcessor = queryProcessor;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()), (Control)this);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(2).equalWidth(false).applyTo((Composite)this);
        this.createFilterText(this);
        this.createFilterCancelIcon(this);
        this.setBackground(this.filterText.getBackground());
        this.addTextModifyListener();
        this.addExplorerSelectionListener();
    }

    private void createFilterText(FilterArea filterArea) {
        this.filterText = new Text((Composite)this, 260);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filterText);
        this.filterText.setFont(this.resourceManager.createFont(FontDescriptor.createFrom((Font)this.filterText.getFont()).increaseHeight(-1)));
        if ((this.filterText.getStyle() & 0x100) != 0) {
            this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (e.detail == 256) {
                        FilterArea.this.clearText();
                    }
                }
            });
        }
        GridData gridData = new GridData(4, 0x1000000, true, true);
        if ((this.filterText.getStyle() & 0x100) != 0) {
            gridData.horizontalSpan = 2;
        }
        this.filterText.setLayoutData((Object)gridData);
    }

    private void createFilterCancelIcon(Composite parent) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            final Image inactiveImage = WorkbenchImages.getImage((String)"IMG_ETOOL_CLEAR_DISABLED");
            final Image activeImage = WorkbenchImages.getImage((String)"IMG_ETOOL_CLEAR");
            final Image pressedImage = (Image)this.resourceManager.get((DeviceResourceDescriptor)ImageDescriptor.createWithFlags((ImageDescriptor)ImageDescriptor.createFromImage((Image)activeImage), (int)2));
            final Label clearButton = new Label(parent, 0);
            clearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            clearButton.setImage(inactiveImage);
            clearButton.setBackground(parent.getDisplay().getSystemColor(25));
            clearButton.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
            clearButton.addMouseListener((MouseListener)new MouseAdapter(){
                private MouseMoveListener fMoveListener;

                public void mouseDown(MouseEvent e) {
                    clearButton.setImage(pressedImage);
                    this.fMoveListener = new MouseMoveListener(){
                        private boolean fMouseInButton = true;

                        public void mouseMove(MouseEvent e) {
                            boolean mouseInButton = this.isMouseInButton(e);
                            if (mouseInButton != this.fMouseInButton) {
                                this.fMouseInButton = mouseInButton;
                                clearButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                            }
                        }
                    };
                    clearButton.addMouseMoveListener(this.fMoveListener);
                }

                public void mouseUp(MouseEvent e) {
                    if (this.fMoveListener != null) {
                        clearButton.removeMouseMoveListener(this.fMoveListener);
                        this.fMoveListener = null;
                        boolean mouseInButton = this.isMouseInButton(e);
                        clearButton.setImage(mouseInButton ? activeImage : inactiveImage);
                        if (mouseInButton) {
                            FilterArea.this.clearText();
                            FilterArea.this.filterText.setFocus();
                        }
                    }
                }

                private boolean isMouseInButton(MouseEvent e) {
                    Point buttonSize = clearButton.getSize();
                    return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
                }
            });
            clearButton.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    clearButton.setImage(activeImage);
                }

                public void mouseExit(MouseEvent e) {
                    clearButton.setImage(inactiveImage);
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            clearButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = WorkbenchMessages.FilteredTree_ClearToolTip;
                }
            });
            clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
            this.clearButtonControl = clearButton;
        }
    }

    protected void clearText() {
        this.filterText.setText("");
        this.explorer.select(null);
    }

    protected void addTextModifyListener() {
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filter = FilterArea.this.filterText.getText();
                FilterArea.this.setFilter(filter, false);
            }
        });
    }

    public void setFilter(String filter) {
        this.setFilter(filter, true);
    }

    protected void setFilter(final String filter, final boolean updateUI) {
        final NodeContext context = this.getFilteredNode();
        if (context == null) {
            return;
        }
        AtomicInteger i = this.modCount.get(context);
        if (i == null) {
            this.modCount.put(context, new AtomicInteger());
        }
        final AtomicInteger counter = this.modCount.get(context);
        final int count = counter.incrementAndGet();
        ThreadUtils.getNonBlockingWorkExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                int newCount = counter.get();
                if (newCount != count) {
                    return;
                }
                FilterArea.this.modCount.remove(context);
                if (FilterArea.this.isDisposed()) {
                    return;
                }
                ThreadUtils.asyncExec((IThreadWorkQueue)SWTThread.getThreadAccess((Display)FilterArea.this.getDisplay()), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (FilterArea.this.isDisposed()) {
                            return;
                        }
                        FilterArea.this.applyFilter(context, filter, updateUI);
                    }
                });
            }
        }, (long)FILTER_DELAY.intValue(), TimeUnit.MILLISECONDS);
    }

    protected void applyFilter(String filter) {
        NodeContext context = this.getFilteredNode();
        if (context != null) {
            this.applyFilter(context, filter, true);
        }
    }

    protected void applyFilter(NodeContext context, String filter, boolean updateUI) {
        String current;
        if (updateUI && !(current = this.filterText.getText()).equals(filter)) {
            this.filterText.setText(filter);
        }
        this.queryProcessor.setFilter(context, filter.isEmpty() ? null : filter);
    }

    protected void addExplorerSelectionListener() {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)this.explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                NodeContext context = (NodeContext)ISelectionUtils.getSinglePossibleKey((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, NodeContext.class);
                if (context == null) {
                    context = (NodeContext)ISelectionUtils.filterSingleSelection((Object)selection, NodeContext.class);
                }
                if (context == null) {
                    context = FilterArea.this.explorer.getRoot();
                }
                if (!$assertionsDisabled && context == null) {
                    throw new AssertionError();
                }
                String filter = FilterArea.this.queryProcessor.getFilter(context);
                if (filter == null) {
                    filter = "";
                }
                FilterArea.this.currentContext = context;
                FilterArea.this.filterText.setText(filter);
            }
        });
    }

    protected NodeContext getFilteredNode() {
        if (this.currentContext != null) {
            return this.currentContext;
        }
        return this.explorer.getRoot();
    }

    public void focus() {
        if (this.filterText.isDisposed()) {
            return;
        }
        Display d = this.filterText.getDisplay();
        if (d.getThread() == Thread.currentThread()) {
            this.doSetFocus();
        } else {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (FilterArea.this.filterText.isDisposed()) {
                        return;
                    }
                    FilterArea.this.doSetFocus();
                }
            });
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.resourceManager.dispose();
        this.explorer = null;
        this.queryProcessor = null;
        this.filterText = null;
        this.currentContext = null;
        this.clearButtonControl = null;
        super.dispose();
    }

    protected void doSetFocus() {
        this.filterText.selectAll();
        this.filterText.setFocus();
    }

    public IFilterArea getFilterArea() {
        return this;
    }
}

