/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.imagers.ContainerImager;
import org.simantics.browsing.ui.common.property.IArrayProperty;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.icons.ImageUtil;
import org.simantics.utils.ui.BundleUtils;

public class ArrayPropertyImagerFactory
implements ImagerFactory {
    public Imager create(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ImagerKey key) {
        Resource inputResource;
        assert (updater != null);
        assert (context != null);
        ContainerImager result = new ContainerImager();
        DataSource source = updater.getDataSource(ReadGraph.class);
        if (source == null) {
            return result;
        }
        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o instanceof IArrayProperty) {
            IArrayProperty prop = (IArrayProperty)o;
            if (prop.getRange().size() > 1) {
                if (prop.isSlice()) {
                    result.setImage("Property", (Object)BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.browsing.ui.common", (String)"/icons/segment_edit.gif"));
                    return result;
                }
            } else {
                return result;
            }
        }
        if ((inputResource = (Resource)context.getAdapter(Resource.class)) == null) {
            return result;
        }
        source.schedule(graph -> {
            try {
                ImageDescriptor descriptor = ImageUtil.adaptImageDescriptor((ReadGraph)graph, (Resource)inputResource);
                result.setImage("Property", (Object)descriptor);
                updater.scheduleReplace(context, (NodeContext.PrimitiveQueryKey)key, (Object)result);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        });
        return result;
    }
}

