/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets.impl;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Text;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.ReflectionUtils;
import org.simantics.utils.ui.ISelectionUtils;

public abstract class TextModifyListenerImpl<T> implements TextModifyListener, Widget {

	protected ISessionContext context;
	protected Object lastInput = null;

	protected final Class<?> clazz;

	public TextModifyListenerImpl() {
		clazz = ReflectionUtils.getSingleParameterType(getClass());
	}

	private Object getInputContents(Object input, Class<?> inputClass) {
		if (inputClass.isInstance(input))
			return input;
		if (input instanceof ISelection)
			return ISelectionUtils.filterSingleSelection(input, inputClass);
		return null;
	}

	@Override
	public void modifyText(TrackedModifyEvent e) {

		Text text = (Text)e.getWidget();
		final String textValue = text.getText();
		final Object input = lastInput;

		try {
			context.getSession().syncRequest(new WriteRequest() {

				@SuppressWarnings("unchecked")
				@Override
				public void perform(WriteGraph graph) throws DatabaseException {
					graph.markUndoPoint();
					if(clazz.isInstance(input)) {
						applyText(graph, (T)input, textValue);
						Layer0Utils.addCommentMetadata(graph, "Modified " + input.toString() + " to " + textValue);
					} else {
						T single = (T)getInputContents(input, clazz);
						if(single != null) {
							applyText(graph, single, textValue);
							Layer0Utils.addCommentMetadata(graph, "Modified " + single.toString() + " to " + textValue);
						}
					}
					
					
				}
				
			});
		} catch (DatabaseException e1) {
			e1.printStackTrace();
		}
	}

	@Override
	public void setInput(ISessionContext context, Object parameter) {
		this.context = context;
		lastInput = parameter;
	}

	abstract public void applyText(WriteGraph graph, T input, String text) throws DatabaseException;

}
	