/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ReadInterface;
import org.simantics.ui.colors.Colors;

abstract public class WidgetImpl implements Widget {

	protected final WidgetSupport support;
	
	public WidgetImpl(WidgetSupport support) {
		this.support = support;
	}
	
	public abstract Control getControl();
	
	public void setFont(Font font) {
		getControl().setFont(font);
	}
	
	public void setBackground(Color color) {
		getControl().setBackground(color);
	}
	
    public <T> void setBackground(final ReadInterface<org.simantics.datatypes.adt.Color> read) {
    	
    	Simantics.getSession().async(read, new Listener<org.simantics.datatypes.adt.Color>() {

    		@Override
    		public void exception(Throwable t) {
    			t.printStackTrace();
    		}

    		@Override
    		public void execute(final org.simantics.datatypes.adt.Color color) {

    			if(isDisposed()) return;

    			getControl().getDisplay().asyncExec(new Runnable() {

    				@Override
    				public void run() {
    					getControl().setBackground(Colors.swt(getControl().getDisplay(), color));
    				}

    			});
    		}

    		@Override
    		public boolean isDisposed() {
    			return getControl().isDisposed();
    		}

    	});

    }
	
	public void setForeground(Color color) {
		getControl().setForeground(color);
	}
	
    public void setLayoutData(Object layoutData) {
    	getControl().setLayoutData(layoutData);
    }

}
