/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.databoard.Bindings;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;


public class VariableStringPropertyTextModifier extends TextModifyListenerImpl<Variable> {

	final private String property;
	
	public VariableStringPropertyTextModifier(String property) {
		this.property = property;
	}

	@Override
	public void applyText(WriteGraph graph, Variable variable, String text) throws DatabaseException {

		variable.setPropertyValue(graph, property, text, Bindings.STRING);
		
	}
	
}