/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.Collections;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.node.ConstantInput;

final public class SWTConstantInput extends ConstantInput<ImageDescriptor> {
	
	final private static Map<String, ImageDescriptor> NO_IMAGES = Collections.emptyMap(); 
	
    public SWTConstantInput(Map<String, String> labels, Map<String, ImageDescriptor> imageDescriptors, int category) {
		super(labels, imageDescriptors, category);
	}

	public static SWTConstantInput create(String label) {
    	return new SWTConstantInput(Collections.singletonMap(ColumnKeys.SINGLE, label), NO_IMAGES, 0);
    }

	public static SWTConstantInput create(String label, ImageDescriptor descriptor) {
    	return new SWTConstantInput(Collections.singletonMap(ColumnKeys.SINGLE, label), Collections.singletonMap(ColumnKeys.SINGLE, descriptor), 0);
    }

	@Override
	public int hashCode() {
		return labels.hashCode() + 31 * imageDescriptors.hashCode() + 41 * category;
	}
	
    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (SWTConstantInput.class != object.getClass())
            return false;
        SWTConstantInput r = (SWTConstantInput)object;
        return r.labels.equals(labels) && r.imageDescriptors.equals(imageDescriptors) && r.category == category;
    }
	
}
