/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.function.Consumer;

import org.simantics.db.procedure.Procedure;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class PartNameProcedure implements Procedure<String> {

    protected final Consumer<String> updateCallback;

    public PartNameProcedure(Consumer<String> updateCallback) {
        assert updateCallback != null;
        this.updateCallback = updateCallback;
    }

    @Override
    public void execute(String result) {
        // System.out.println("part name changed: " + result);
        updateCallback.accept(result);
    }

    @Override
    public void exception(Throwable t) {
        ErrorLogger.defaultLogError(t);
    }

}
