/*******************************************************************************
 * Copyright (c) 2012, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - gitlab #1072
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.Collections;
import java.util.List;

import org.simantics.browsing.ui.model.nodetypes.EntityNodeType;
import org.simantics.browsing.ui.model.nodetypes.SpecialNodeType;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.db.Resource;

public class NodeContextValueBean extends Bean {

	private static final Binding BINDING = Bindings.getBindingUnchecked(NodeContextValueBean.class);

	public String name;
	public Resource resource;
	public List<Resource> resources;
	public String className;

	public NodeContextValueBean(EntityNodeType ent) {
		super(BINDING);
		name = EntityNodeType.class.getName();
		resource = ent.entityTypes.get(0);
		resources = ent.entityTypes;
		className = "";
	}

	public NodeContextValueBean(SpecialNodeType ent) {
		super(BINDING);
		assert(ent.resource != null);
		name = SpecialNodeType.class.getName();
		resource = ent.resource;
		resources = Collections.singletonList(ent.resource);
		className = ent.getContentType().getName();
	}

	public NodeContextValueBean(Resource resource) {
		super(BINDING);
		assert(resource != null);
		name = Resource.class.getName();
		this.resource = resource;
		this.resources = Collections.singletonList(resource);
		className = "";
	}

}
