/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.browsing.ui.swt.widgets.Combo;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.Pair;

/**
 * @author Antti Villberg
 */
public class ModelledCombo implements ModelledControl {

    final private Resource configuration;

    public ModelledCombo(Resource configuration) {
        this.configuration = configuration;
    }

    @Override
    public Control create(Composite parent, IWorkbenchSite site, ISessionContext context, WidgetSupport support) throws DatabaseException {

    	Combo combo = new Combo(parent, support, SWT.READ_ONLY);
    	
        GridData gridData = Simantics.getSession().syncRequest(new Read<GridData>() {

            @Override
            public GridData perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance(graph);
                GridData data = new GridData(SWT.FILL, SWT.FILL, true, false);                
                Integer span = graph.getPossibleRelatedValue(configuration, br.Control_HorizontalSpan, Bindings.INTEGER);
                if(span != null) data.horizontalSpan = span;
                Boolean grabExcessHorizontalSpace = graph.getPossibleRelatedValue(configuration, br.Control_HorizontalGrab, Bindings.BOOLEAN);
                if(grabExcessHorizontalSpace != null) data.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
                return data;
            }

        });
    	
        combo.setLayoutData(gridData);

        ReadFactory<?, List<Pair<String, Object>>> available = Simantics.getSession().syncRequest(new Read<ReadFactory<?, List<Pair<String, Object>>>>() {

            @SuppressWarnings("unchecked")
            @Override
            public ReadFactory<?, List<Pair<String, Object>>> perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance(graph);
                Resource factory = graph.getPossibleObject(configuration, br.Combo_AvailableItems);
                return graph.adapt(factory, ReadFactory.class);
            }

        });

        //System.err.println("ModelledCombo: items = " + available);

        combo.setItemFactory2(available);

        ReadFactory<?, String> selected = Simantics.getSession().syncRequest(new Read<ReadFactory<?, String>>() {

            @SuppressWarnings("unchecked")
            @Override
            public ReadFactory<?, String> perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance(graph);
                Resource factory = graph.getPossibleObject(configuration, br.Combo_SelectedItem);
                return graph.adapt(factory, ReadFactory.class);
            }

        });

        combo.setSelectionFactory(selected);

        ModifyListener modifier = Simantics.getSession().syncRequest(new Read<ModifyListener>() {

            @Override
            public ModifyListener perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance(graph);
                Resource factory = graph.getPossibleObject(configuration, br.Combo_Modifier);
                return graph.adapt(factory, ModifyListener.class);
            }

        });

        combo.addModifyListener(modifier);

        return combo.getWidget();
    }

}
