/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.Set;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.Column.Align;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.graph.impl.GraphInputSources;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.ArrayMap;

/*
 * A dialog, which contains a single graph explorer composite
 *
 * Override getBrowseContexts() to specify the graph explorer contents.
 * 
 */

public abstract class GraphExplorerDialog2 extends SimanticsDialog {

    abstract public Set<String> getBrowseContexts();

    private final IWorkbenchSite site;
    private final DataContainer<Object[]> result = new DataContainer<Object[]>();
    
    private GraphExplorerComposite outputExplorer;

    public GraphExplorerDialog2(IWorkbenchSite site, String title) {
        super(Display.getCurrent().getActiveShell(), title);
        this.site = site;
    }

    Column[] getColumns() {
        return new Column[] { new Column(ColumnKeys.SINGLE, Align.RIGHT, 180, "single", true, 1) };
    }

    @Override
    protected SessionContextInputSource getInputSource() {
        return GraphInputSources.projectSource();
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    protected void createControls(Composite body, ISessionContext context, WidgetSupport support) {

        outputExplorer = new GraphExplorerComposite(
                ArrayMap.keys("displaySelectors", "displayFilter").values(false, false), site, body, support,
                SWT.BORDER);
        outputExplorer.setBrowseContexts(getBrowseContexts());
        outputExplorer.setColumnsVisible(false);
        outputExplorer.setColumns(getColumns());
        outputExplorer.finish();

        outputExplorer.setBackground(body.getDisplay().getSystemColor(SWT.COLOR_GREEN));

        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).minSize(300, 400).applyTo(outputExplorer);

    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId == Window.OK) {

            Tree tree = (Tree) outputExplorer.getExplorerControl();

            TreeItem[] selectedItems = tree.getSelection();
            Object[] res = new Object[selectedItems.length];
            for (int i = 0; i < selectedItems.length; i++) {
                res[i] = selectedItems[i].getData();
            }
            result.set(res);
        }
        super.buttonPressed(buttonId);

    }

    public Object[] getSelection() {
        return result.get();
    }
    
    public GraphExplorerComposite getGraphExplorerComposite() {
        return outputExplorer;
    }

}
