/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ImagerKey;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.imagers.ContainerImager;
import org.simantics.browsing.ui.common.property.IArrayProperty;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.icons.ImageUtil;
import org.simantics.utils.ui.BundleUtils;

/**
 * A basic imager factory with support for both Resource and IArrayProperty.
 * 
 * @author Tuukka Lehtonen
 */
public class ArrayPropertyImagerFactory implements ImagerFactory {

    @SuppressWarnings("unchecked")
    @Override
    public Imager create(final PrimitiveQueryUpdater updater, final NodeContext context, final ImagerKey key) {
        assert updater != null;
        assert context != null;

        @SuppressWarnings("rawtypes")
        final ContainerImager result = new ContainerImager();
        final DataSource<ReadGraph> source = updater.getDataSource(ReadGraph.class);
        if (source == null)
            return result;

        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o instanceof IArrayProperty) {
            IArrayProperty prop = (IArrayProperty) o;

            if (prop.getRange().size() > 1) {
                // Only show the segment image for non-single-item slices of the
                // property root node. Otherwise just use the image resolved
                // through normal means.
                if (prop.isSlice()) {
                    result.setImage(ColumnKeys.PROPERTY,
                            BundleUtils.getImageDescriptorFromPlugin(
                                    "org.simantics.browsing.ui.common", "/icons/segment_edit.gif"));
                    return result;
                }
            } else {
                // No image for single-item slices of the property.
                return result;
            }
        }

        final Resource inputResource = (Resource) context.getAdapter(Resource.class);
        if (inputResource == null)
            return result;

        source.schedule(graph -> {
            ImageDescriptor descriptor;
            try {
                descriptor = ImageUtil.adaptImageDescriptor(graph, inputResource);
                result.setImage(ColumnKeys.PROPERTY, descriptor);
                updater.scheduleReplace(context, key, result);
            } catch (DatabaseException e) {
                e.printStackTrace();
            }
        });

        return result;
    }

}
