/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.content;

/**
 * @author Tuukka Lehtonen
 */
public interface ImageDecorator {

    /**
     * @param image the original image
     * @return the decorated image or <code>null</code> to denote
     *         <em>no decoration</em>.
     */
    <Image> Image decorateImage(Image image, String column, int itemIndex);

    /**
     * Stub for a NOP-implementation of a ImageDecorator.
     */
    public static class Stub implements ImageDecorator {
        @Override
        public <Image> Image decorateImage(Image image, String column, int itemIndex) {
            return null;
        }
    }

}
