/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui;

import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;

public interface PrimitiveQueryProcessor<T> {

    /**
     * Specifies the key object that is used to identify queries that this
     * processor is capable of serving.
     * 
     * @return the key object that uniquely represents the query that this
     *         processor can respond to.
     */
    Object getIdentifier();

    /**
     * @param updater
     * @param context
     * @param key
     * @return the result of the query
     */
    T query(PrimitiveQueryUpdater updater, NodeContext context, PrimitiveQueryKey<T> key);

}
