/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.platform;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.osgi.framework.Bundle;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.EvaluatorDataImpl;
import org.simantics.browsing.ui.common.node.IDropTargetNode;
import org.simantics.browsing.ui.common.processors.ComparableFactoryResolver;
import org.simantics.browsing.ui.common.processors.ComparableSelectorQueryProcessor;
import org.simantics.browsing.ui.common.processors.FilterSelectionRequestQueryProcessor;
import org.simantics.browsing.ui.common.processors.ImageDecoratorFactoryResolver;
import org.simantics.browsing.ui.common.processors.ImagerFactoryResolver;
import org.simantics.browsing.ui.common.processors.LabelDecoratorFactoryResolver;
import org.simantics.browsing.ui.common.processors.LabelerFactoryResolver;
import org.simantics.browsing.ui.common.processors.UserSelectedComparableFactoryQueryProcessor;
import org.simantics.browsing.ui.common.processors.UserSelectedViewpointFactoryQueryProcessor;
import org.simantics.browsing.ui.common.processors.ViewpointFactoryResolver;
import org.simantics.browsing.ui.common.views.IFilterAreaProvider;
import org.simantics.browsing.ui.graph.impl.AsyncReadGraphDataSource;
import org.simantics.browsing.ui.graph.impl.Evaluators;
import org.simantics.browsing.ui.graph.impl.GraphExplorerHints;
import org.simantics.browsing.ui.graph.impl.InheritsQueryProcessor;
import org.simantics.browsing.ui.graph.impl.ReadGraphDataSource;
import org.simantics.browsing.ui.graph.impl.RelatedObjectsQueryProcessor;
import org.simantics.browsing.ui.swt.ComparatorSelector;
import org.simantics.browsing.ui.swt.FilterArea;
import org.simantics.browsing.ui.swt.GraphExplorerViewBase;
import org.simantics.browsing.ui.swt.StandardContextTypesQueryProcessor;
import org.simantics.browsing.ui.swt.TypesQueryProcessor;
import org.simantics.browsing.ui.swt.ViewpointSelector;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Session;
import org.simantics.db.management.ISessionContext;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalSelectionDragSourceListener;
import org.simantics.ui.dnd.NoImageDragSourceEffect;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.LayoutUtils;

public class GraphExplorerView
extends GraphExplorerViewBase {
    protected UserSelectedComparableFactoryQueryProcessor userSelectedComparableFactoryQueryProcessor;
    protected UserSelectedViewpointFactoryQueryProcessor userSelectedViewpointFactoryQueryProcessor;
    protected FilterSelectionRequestQueryProcessor filterSelectionRequestQueryProcessor;
    protected FilterArea filterArea;
    protected IHintContext factoryHints = new HintContext();
    protected EvaluatorData evaluatorData;
    protected Set<String> browseContexts = Collections.emptySet();
    protected String contextMenuId;
    protected Set<String> uiContexts = Collections.emptySet();
    protected String propertyPageContributor;
    protected String propertyPageClassName;
    protected Set<String> propertyBrowseContexts = Collections.emptySet();
    protected boolean hideComparatorSelector = false;
    protected boolean hideViewpointSelector = false;
    protected boolean hideFilter = false;

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        if (data instanceof String) {
            HashSet<String> browseContexts = new HashSet<String>();
            HashSet<String> uiContexts = new HashSet<String>();
            HashSet<String> propertyBrowseContexts = new HashSet<String>();
            String[] parameters = ((String)data).split(";");
            IContextService service = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            HashSet<String> definedContexts = new HashSet<String>();
            for (Object cid : service.getDefinedContextIds()) {
                definedContexts.add((String)cid);
            }
            String[] stringArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                String[] keyValue = parameter.split("=");
                if (keyValue.length > 2) {
                    ErrorLogger.defaultLogWarning((String)("Invalid parameter '" + parameter + ". Complete view argument: " + String.valueOf(data)), null);
                } else {
                    String value;
                    String key = keyValue[0];
                    String string = value = keyValue.length > 1 ? keyValue[1] : "";
                    if ("browseContext".equals(key)) {
                        browseContexts.add(value);
                    } else if ("contextMenuId".equals(key)) {
                        this.contextMenuId = value;
                    } else if ("uiContext".equals(key)) {
                        if (!definedContexts.contains(value)) {
                            ErrorLogger.defaultLogWarning((String)("Parameter '" + parameter + "' references a non-existent Eclipse UI context '" + value + "'. Complete view argument: " + String.valueOf(data)), null);
                        } else {
                            uiContexts.add(value);
                        }
                    } else if ("propertyBrowseContext".equals(key)) {
                        propertyBrowseContexts.add(value);
                    } else if ("propertyPageClass".equals(key)) {
                        this.propertyPageContributor = cfig.getContributor().getName();
                        this.propertyPageClassName = value;
                    } else if ("hideComparatorSelector".equals(key)) {
                        this.hideComparatorSelector = true;
                    } else if ("hideViewpointSelector".equals(key)) {
                        this.hideViewpointSelector = true;
                    } else if ("hideFilter".equals(key)) {
                        this.hideFilter = true;
                    }
                }
                ++n2;
            }
            this.browseContexts = browseContexts;
            this.uiContexts = uiContexts;
            this.propertyBrowseContexts = propertyBrowseContexts;
        }
    }

    public GraphExplorer getExplorer() {
        return this.explorer;
    }

    public <T> T getBrowseContext() {
        return (T)this.evaluatorData.getBrowseContext();
    }

    protected Set<String> getBrowseContexts() {
        return this.browseContexts;
    }

    protected String getContextMenuId() {
        return this.contextMenuId;
    }

    protected Set<String> getUiContexts() {
        return this.uiContexts;
    }

    protected IPropertyPage getPropertyPage() {
        if (this.propertyPageContributor != null && this.propertyPageClassName != null) {
            Class clazz;
            block8: {
                Bundle b;
                block7: {
                    b = Platform.getBundle((String)this.propertyPageContributor);
                    if (b != null) break block7;
                    ErrorLogger.defaultLogError((String)("property page '" + this.propertyPageClassName + "' contributor bundle '" + this.propertyPageContributor + "' was not found in the platform."), null);
                    return null;
                }
                clazz = b.loadClass(this.propertyPageClassName);
                if (IPropertyPage.class.isAssignableFrom(clazz)) break block8;
                ErrorLogger.defaultLogError((String)("property page class '" + this.propertyPageClassName + "' is not assignable to " + String.valueOf(IPropertyPage.class) + "."), null);
                return null;
            }
            try {
                Constructor ctor = clazz.getConstructor(IWorkbenchPartSite.class);
                return (IPropertyPage)ctor.newInstance(this.getSite());
            }
            catch (Exception e) {
                ErrorLogger.defaultLogError((String)("Failed to instantiate IPropertyPage implementation '" + this.propertyPageClassName + "' from bundle '" + this.propertyPageContributor + "'. See exception for details."), (Throwable)e);
                this.propertyPageClassName = null;
            }
        } else if (!this.propertyBrowseContexts.isEmpty()) {
            return new StandardPropertyPage(this.getSite(), new HashSet<String>(this.propertyBrowseContexts));
        }
        return null;
    }

    protected void createControls(Composite parent) {
        super.createControls(parent);
        Control control = (Control)this.explorer.getControl();
        this.userSelectedComparableFactoryQueryProcessor = new UserSelectedComparableFactoryQueryProcessor();
        this.userSelectedViewpointFactoryQueryProcessor = new UserSelectedViewpointFactoryQueryProcessor();
        this.filterSelectionRequestQueryProcessor = new FilterSelectionRequestQueryProcessor();
        this.createAuxiliaryControls(parent, control);
        this.setupDropTarget(control);
        this.setWorkbenchListeners();
        this.activateUiContexts();
    }

    protected void createAuxiliaryControls(Composite parent, Control explorerControl) {
        if (explorerControl instanceof Tree) {
            parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)3, (boolean)false));
        }
        if (!this.hideComparatorSelector) {
            ComparatorSelector comparatorSelector = new ComparatorSelector(this.explorer, this.userSelectedComparableFactoryQueryProcessor, parent, 8);
            comparatorSelector.moveAbove(explorerControl);
        }
        if (!this.hideViewpointSelector) {
            ViewpointSelector viewpointSelector = new ViewpointSelector(this.explorer, this.userSelectedViewpointFactoryQueryProcessor, parent, 8);
            viewpointSelector.moveAbove(explorerControl);
        }
        if (!this.hideFilter) {
            this.filterArea = new FilterArea(this.explorer, this.filterSelectionRequestQueryProcessor, parent, 8);
            this.filterArea.moveAbove(explorerControl);
        }
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo(explorerControl);
    }

    protected void setupDropTarget(Control control) {
        DropTarget target = new DropTarget(control, 5);
        target.setTransfer(this.getAcceptedDataTypes());
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){
            Tree tree;
            {
                this.tree = (Tree)GraphExplorerView.this.explorer.getControl();
            }

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                TreeItem item = this.tree.getItem(this.tree.toControl(event.x, event.y));
                if (item != null) {
                    GraphExplorerView.this.handleDrop(event.data, (NodeContext)item.getData());
                } else {
                    GraphExplorerView.this.handleDrop(event.data, null);
                }
            }
        });
    }

    protected void activateUiContexts() {
        Set<String> contexts = this.getUiContexts();
        if (!contexts.isEmpty()) {
            IContextService cs = (IContextService)this.getSite().getService(IContextService.class);
            for (String context : contexts) {
                cs.activateContext(context);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFilterAreaProvider.class) {
            return this.filterArea;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        this.removeWorkbenchListeners();
        this.userSelectedComparableFactoryQueryProcessor = null;
        this.userSelectedViewpointFactoryQueryProcessor = null;
        this.filterSelectionRequestQueryProcessor = null;
        super.dispose();
    }

    protected final void initializeExplorer(GraphExplorer explorer, ISessionContext context) {
        Session session;
        if (explorer.isDisposed()) {
            return;
        }
        super.initializeExplorer(explorer, context);
        Session session2 = session = context != null ? context.getSession() : null;
        if (session != null) {
            this.evaluatorData = this.createEvaluatorData(session);
            this.factoryHints.setHint(GraphExplorerHints.KEY_SESSION_CONTEXT, (Object)context);
            explorer.setDataSource((DataSource)new AsyncReadGraphDataSource((AsyncRequestProcessor)session));
            explorer.setDataSource((DataSource)new ReadGraphDataSource((AsyncRequestProcessor)session));
        } else {
            this.evaluatorData = new EvaluatorDataImpl();
            explorer.removeDataSource(AsyncReadGraph.class);
            explorer.removeDataSource(ReadGraph.class);
            this.factoryHints.removeHint(GraphExplorerHints.KEY_SESSION_CONTEXT);
        }
        explorer.setProcessor((NodeQueryProcessor)new ComparableFactoryResolver(this.evaluatorData));
        explorer.setProcessor((NodeQueryProcessor)new ViewpointFactoryResolver(this.evaluatorData));
        explorer.setProcessor((NodeQueryProcessor)new LabelerFactoryResolver(this.evaluatorData));
        explorer.setProcessor((NodeQueryProcessor)new ImagerFactoryResolver(this.evaluatorData));
        explorer.setProcessor((NodeQueryProcessor)new LabelDecoratorFactoryResolver(this.evaluatorData));
        explorer.setProcessor((NodeQueryProcessor)new ImageDecoratorFactoryResolver(this.evaluatorData));
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new TypesQueryProcessor());
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new StandardContextTypesQueryProcessor());
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new InheritsQueryProcessor());
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new RelatedObjectsQueryProcessor());
        if (!this.hideViewpointSelector) {
            explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)this.userSelectedViewpointFactoryQueryProcessor);
            explorer.setProcessor((NodeQueryProcessor)new ComparableSelectorQueryProcessor());
        }
        if (!this.hideComparatorSelector) {
            explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)this.userSelectedComparableFactoryQueryProcessor);
        }
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)this.filterSelectionRequestQueryProcessor);
        this.initializeExplorerWithEvaluator(explorer, context, this.evaluatorData);
    }

    protected void initializeExplorerWithEvaluator(GraphExplorer explorer, ISessionContext context, EvaluatorData data) {
    }

    protected EvaluatorData createEvaluatorData(Session session) {
        return Evaluators.load((RequestProcessor)session, this.getBrowseContexts(), (ResourceManager)this.resourceManager);
    }

    protected Transfer[] getAcceptedDataTypes() {
        return new Transfer[]{LocalObjectTransfer.getTransfer(), FileTransfer.getInstance()};
    }

    protected void handleDrop(Object data, NodeContext target) {
        Object input;
        if (target != null && (input = target.getConstant(BuiltinKeys.INPUT)) instanceof IDropTargetNode) {
            ((IDropTargetNode)input).drop(data);
        }
    }

    protected Object createDragSource(GraphExplorer explorer) {
        ISelectionProvider selectionProvider = (ISelectionProvider)explorer.getAdapter(ISelectionProvider.class);
        LocalSelectionDragSourceListener listener = new LocalSelectionDragSourceListener(selectionProvider);
        Control control = (Control)explorer.getControl();
        DragSource source = new DragSource(control, 23);
        source.setTransfer(new Transfer[]{LocalObjectTransfer.getTransfer()});
        source.addDragListener((DragSourceListener)listener);
        source.setDragSourceEffect((DragSourceEffect)new NoImageDragSourceEffect(control));
        return listener;
    }

    public EvaluatorData getEvaluatorData() {
        return this.evaluatorData;
    }
}

