/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.nattable.NatTableGraphExplorer;
import org.simantics.browsing.ui.nattable.RowSelectionItem;
import org.simantics.browsing.ui.nattable.TreeNode;
import org.simantics.utils.ui.AdaptionUtils;

public class KeyToSelectionAdapter
extends KeyAdapter {
    private static final int KEY_INPUT_DELAY = 500;
    private final NatTableGraphExplorer explorer;
    private String matcher = "";
    private int prevEvent = 0;
    private int columns = 0;
    protected Pattern alphaNum;
    private TreeNode previous = null;
    private boolean foundPrev = false;

    public KeyToSelectionAdapter(GraphExplorer explorer) {
        this(explorer, "\\p{Alnum}");
    }

    public KeyToSelectionAdapter(GraphExplorer explorer, String pattern) {
        assert (explorer != null);
        this.explorer = (NatTableGraphExplorer)explorer;
        this.alphaNum = Pattern.compile(pattern);
    }

    public boolean acceptKey(char key) {
        return this.alphaNum.matcher(Character.toString(key)).matches();
    }

    public void keyPressed(KeyEvent e) {
        if (this.explorer.isDisposed()) {
            return;
        }
        if (!this.acceptKey(e.character)) {
            return;
        }
        if (e.time - this.prevEvent > 500) {
            this.matcher = "";
        }
        this.prevEvent = e.time;
        this.matcher = this.matcher = String.valueOf(this.matcher) + Character.toString(e.character);
        NatTable tree = (NatTable)this.explorer.getControl();
        this.columns = this.explorer.getColumns().length;
        IStructuredSelection sel = (IStructuredSelection)this.explorer.getWidgetSelection();
        Collection selected = AdaptionUtils.adaptToCollection((Object)sel, RowSelectionItem.class);
        TreeNode item = this.find(tree, selected);
        if (item == null && this.matcher.length() > 1) {
            this.matcher = this.matcher.substring(this.matcher.length() - 1);
            item = this.find(tree, selected);
        }
        if (item != null) {
            this.explorer.show(item);
            this.explorer.select(item);
        }
        e.doit = false;
    }

    private TreeNode find(NatTable tree, Collection<RowSelectionItem> selected) {
        TreeNode item = null;
        List<TreeNode> items = this.explorer.getItems();
        if (selected.size() == 0) {
            this.previous = null;
            this.foundPrev = true;
            item = this.findItem(items);
        } else {
            this.previous = selected.iterator().next().item;
            this.foundPrev = false;
            item = this.findItem(items);
            if (item == null) {
                this.previous = null;
                this.foundPrev = true;
                item = this.findItem(items);
            }
        }
        return item;
    }

    private TreeNode findItem(List<TreeNode> items) {
        int i = 0;
        while (i < items.size()) {
            TreeNode item = items.get(i);
            if (item != this.previous) {
                if (this.foundPrev && this.matches(item, this.columns, this.matcher)) {
                    return item;
                }
            } else {
                this.foundPrev = true;
            }
            ++i;
        }
        return null;
    }

    protected boolean matches(TreeNode item, int columns, String matcher) {
        int c = 0;
        while (c < columns) {
            if (this.matchesColumn(item, c, matcher)) {
                return true;
            }
            ++c;
        }
        return false;
    }

    protected boolean matchesColumn(TreeNode item, int column, String matcher) {
        String text = item.getValueString(column);
        if (text == null) {
            return false;
        }
        return text.toLowerCase().startsWith(matcher);
    }
}

