package org.simantics.browsing.ui.nattable;

import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;

public class GEColumnHeaderDataProvider implements IDataProvider {
	
	NatTableGraphExplorer ge;
	DataLayer dataLayer;
	
	public GEColumnHeaderDataProvider(NatTableGraphExplorer ge, DataLayer dataLayer) {
		this.ge = ge;
		this.dataLayer = dataLayer;
	}
	
	@Override
	public int getColumnCount() {
		return ge.getColumns().length;
	}
	
	@Override
	public int getRowCount() {
		return 1;
	}
	
	@Override
	public Object getDataValue(int columnIndex, int rowIndex) {
		if (columnIndex < 0 || rowIndex < 0)
			return null;
		return ge.getColumns()[columnIndex].getLabel();
	}
	
	@Override
	public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
		throw new java.lang.UnsupportedOperationException();
	}
	
	public void updateColumnSizes() {
		for (int i = 0; i < getColumnCount(); i++) {
			int w = ge.getColumns()[i].getWidth();
			if (w > 0)
				dataLayer.setColumnWidthByPosition(i, w);
		}
	}
	
	public DataLayer getDataLayer() {
		return dataLayer;
	}

}
