package org.simantics.browsing.ui.nattable;

import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.content.Labeler.Modifier;


public class GEColumnAccessor implements IColumnPropertyAccessor<TreeNode> {
	NatTableGraphExplorer ge;
	
	public GEColumnAccessor(NatTableGraphExplorer ge) {
		this.ge = ge;
	}
	
	@Override
	public int getColumnCount() {
		return ge.getColumns().length;
	}
	
	@Override
	public Object getDataValue(TreeNode rowObject, int columnIndex) {
		
		if (columnIndex > 0)
			return rowObject.getValueString(columnIndex);
		else {
			String val = "";
			for (int i = 0 ; i <rowObject.getDepth(); i++)
				val += "   ";
			return val + rowObject.getValueString(columnIndex);
		}
		
		
	}
	
	
	@Override
	public void setDataValue(TreeNode rowObject, int columnIndex, Object newValue) {
		Modifier modifier = ge.getModifier(rowObject, columnIndex);
		if (modifier == null)
			throw new IllegalArgumentException("Items is not modifiable");
		modifier.modify(newValue != null ? newValue.toString() : "");
	}
	
	
	@Override
	public String getColumnProperty(int columnIndex) {
		return ge.getColumns()[columnIndex].getKey();
	}
	
	@Override
	public int getColumnIndex(String propertyName) {
		Column columns[] = ge.getColumns();
		for (int i = 0; i < columns.length; i++) {
			if (columns[i].getKey().equals(propertyName))
				return i;
		}
		return -1;
	}
	
}