/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.children;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class RelationStatementRule
implements ChildRule {
    Resource relation;

    public RelationStatementRule(Resource relation, Test test) {
        this.relation = relation;
    }

    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        ArrayList result = new ArrayList();
        for (Resource property : graph.getPredicates((Resource)parent)) {
            if (!graph.isSubrelationOf(property, this.relation)) continue;
            result.addAll(graph.getStatements((Resource)parent, property));
        }
        return result;
    }

    @Override
    public boolean hasChildren(ReadGraph graph, Object parent) throws DatabaseException {
        for (Resource property : graph.getPredicates((Resource)parent)) {
            if (!graph.isSubrelationOf(property, this.relation) || !graph.hasStatement((Resource)parent, property)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return Collections.emptyList();
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }
}

