/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.modifiers;

import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class L0StringModifier implements Modifier {

	private final RequestProcessor processor;
	private final Resource         subject;
	private final Resource         propertyRelation;
	private final Resource         literal;

	public L0StringModifier(RequestProcessor processor, Resource subject, Resource propertyRelation, Resource literal) {
		this.processor = processor;
		this.subject = subject;
		this.propertyRelation = propertyRelation;
		this.literal = literal;
	}

	@Override
	public String getValue() {
		try {
			return processor.syncRequest(new PossibleAdapter<String>(literal, String.class));
		} catch (DatabaseException e) {
			ErrorLogger.defaultLogError(e);
			return null;
		}
	}

	@Override
	public String isValid(final String label) {
		try {
			return processor.syncRequest(new Read<String>() {
				@Override
				public String perform(ReadGraph graph) throws DatabaseException {
					StringModifier modifier = graph.adapt(literal, StringModifier.class);
					return modifier.isValid(label);
				}
			});
		} catch (DatabaseException e) {
			ErrorLogger.defaultLogError(e);
			return e.getMessage();
		}
	}

	@Override
	public void modify(final String label) {
		try {
			processor.syncRequest(new WriteRequest() {
				@Override
				public void perform(WriteGraph graph) throws DatabaseException {
					Layer0Utils.addCommentMetadata(graph, "Modify string");
            		graph.markUndoPoint();
					Statement stm = graph.getPossibleStatement(subject, propertyRelation);
					if (stm.isAsserted(subject)) {
						Layer0 L0 = Layer0.getInstance(graph);
						Resource newLiteral = graph.newResource();
						for (Resource iof : graph.getObjects(literal, L0.InstanceOf))
							graph.claim(newLiteral, L0.InstanceOf, null, iof);
						graph.claim(subject, propertyRelation, newLiteral);
						StringModifier modifier = graph.adapt(newLiteral, StringModifier.class);
						modifier.modify(graph, label);
					} else {
						StringModifier modifier = graph.adapt(literal, StringModifier.class);
						modifier.modify(graph, label);
					}
				}
			});
		} catch (DatabaseException e) {
			ErrorLogger.defaultLogError(e);
		}
	}

}
