/*******************************************************************************
 * Copyright (c) 2010, 2021 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - hasChildren
 *******************************************************************************/
package org.simantics.browsing.ui.model.children;

import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * A child rule that follows the given relation. Content type of both parent 
 * and child node types must be Resources.
 * @author Hannu Niemistö
 */
public class EqualContentChildRule implements ChildRule {
    Test condition;
    
    public EqualContentChildRule(Test condition) {
    }
    
    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        if(condition != null && !condition.test(graph, parent))
            return Collections.emptyList();
        else
            return Collections.singletonList(parent);
    }

    @Override
    public boolean hasChildren(ReadGraph graph, Object parent) throws DatabaseException {
        return condition == null || condition.test(graph, parent);
    }

    @Override
    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        if(condition != null && !condition.test(graph, child))
            return Collections.emptyList();
        else
            return Collections.singletonList(child);
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        if(condition == null)            
            return true;
        else
            return condition.isCompatible(contentType);
    }
}
