/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.tester;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.Tester;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;

public class EqualsResourceTester
implements Tester {
    private Resource resource;
    private String uri;

    public EqualsResourceTester(Resource resource) {
        this.resource = resource;
    }

    public EqualsResourceTester(RequestProcessor processor, final String uri) throws DatabaseException {
        this.uri = uri;
        processor.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) {
                try {
                    EqualsResourceTester.this.resource = graph.getResource(uri);
                    if (!$assertionsDisabled && EqualsResourceTester.this.resource == null) {
                        throw new AssertionError();
                    }
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean test(NodeQueryManager manager, NodeContext context) {
        return this.resource.equals(context.getConstant(BuiltinKeys.INPUT));
    }

    public String toString() {
        return "Equals resource " + (this.uri != null ? this.uri : "<unknown>");
    }
}

