/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.tester;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.Tester;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;

public class EqualsResourceTester implements Tester {

    private Resource resource;
    private String uri;

    public EqualsResourceTester(Resource resource) {
        this.resource = resource;
    }

    public EqualsResourceTester(RequestProcessor processor, final String uri) throws DatabaseException {

        this.uri = uri;

        processor.syncRequest(new ReadRequest() {

            @Override
            public void run(ReadGraph graph) {
                try {
                    resource = graph.getResource(uri);
                    assert (resource != null);
                } catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }

        });

    }

    @Override
    public boolean test(NodeQueryManager manager, NodeContext context) {
        return resource.equals(context.getConstant(BuiltinKeys.INPUT));
    }

    @Override
    public String toString() {
        return "Equals resource " + (uri != null ? uri : "<unknown>");
    }

}
