/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.contributor.layer0;

import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.graph.contributor.labeler.LabelerContributor;
import org.simantics.browsing.ui.graph.impl.L0StringModifier;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.operation.Layer0X;
import org.simantics.utils.strings.StringUtils;

final public class StringAdapter extends LabelerContributor<Resource> {

	@Override
	public String getLabel(ReadGraph graph, Resource input)
			throws DatabaseException {
//		System.out.println("StringAdapter " + NameUtils.getSafeName(graph, input));
		return StringUtils.safeString(graph.getPossibleAdapter(input, String.class));
	}

	@Override
	public int getCategory(ReadGraph graph, Resource input) throws DatabaseException {
		Integer cat = graph.getPossibleRelatedValue(input, Layer0X.getInstance(graph).DisplayCategory, Bindings.INTEGER);
		return cat != null ? cat : 0;
	}

	@Override
	public Modifier getModifier(ReadGraph graph, Resource input, String columnKey) throws DatabaseException {
		StringModifier modifier = graph.getPossibleAdapter(input, StringModifier.class);
		if (modifier == null)
			return null;
		return new L0StringModifier(graph.getSession(), input);
	}

}
