/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl.contribution;

import java.util.Collections;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.labelers.LabelerContent;
import org.simantics.browsing.ui.common.labelers.LabelerStub;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.request.ResourceQuery;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.UndoContext;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.InvalidVariableException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.utils.ui.ErrorLogger;

public abstract class FinalLabelerContributionImpl
extends LabelerStub {
    protected final PrimitiveQueryUpdater updater;
    private final ResourceQuery<LabelerContent> labelQuery;
    protected final NodeContext context;
    private final BuiltinKeys.LabelerKey key;

    public Object getIdentity(BuiltinKeys.LabelerKey key) {
        return key;
    }

    public FinalLabelerContributionImpl(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.LabelerKey key) {
        this.updater = updater;
        this.context = context;
        this.key = key;
        this.labelQuery = new ResourceQuery<LabelerContent>(this.getIdentity(key), context){

            public LabelerContent perform(ReadGraph graph) throws DatabaseException {
                try {
                    int cat = FinalLabelerContributionImpl.this.category(graph, this.context);
                    Map<String, String> lbls = FinalLabelerContributionImpl.this.labels(graph, this.context);
                    if (lbls == null) {
                        throw new NullPointerException("FinalLabelerContributionImpl.labels is not allowed to return null, but " + String.valueOf(((Object)((Object)FinalLabelerContributionImpl.this)).getClass()) + " just did it");
                    }
                    return new LabelerContent(cat, lbls);
                }
                catch (PendingVariableException pendingVariableException) {
                    return LabelerContent.NO_CONTENT;
                }
                catch (InvalidVariableException invalidVariableException) {
                    return LabelerContent.NO_CONTENT;
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Throwable t) {
                    ErrorLogger.defaultLogError((String)"FinalLabelerContributionImpl.labelQuery produced unexpected exception.", (Throwable)t);
                    return LabelerContent.NO_CONTENT;
                }
            }

            public String toString() {
                return String.valueOf((Object)FinalLabelerContributionImpl.this) + " with context " + String.valueOf(this.context);
            }
        };
    }

    protected Procedure<LabelerContent> createProcedure() {
        return new Procedure<LabelerContent>(){

            public void execute(LabelerContent result) {
                FinalLabelerContributionImpl.this.replaceResult(result);
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((String)"FinalLabelerContributionImpl.labelQuery failed, see exception for details.", (Throwable)t);
            }
        };
    }

    protected void replaceResult(LabelerContent result) {
        this.setContent(result);
        this.updater.scheduleReplace(this.context, (NodeContext.PrimitiveQueryKey)this.key, (Object)this);
    }

    public Map<String, String> getLabels() {
        if (this.content == LabelerContent.NO_CONTENT) {
            DataSource source = this.updater.getDataSource(AsyncReadGraph.class);
            assert (source != null);
            Procedure<LabelerContent> procedure = this.createProcedure();
            source.schedule(graph -> {
                if (procedure instanceof Listener) {
                    graph.asyncRequest(this.labelQuery, (Listener)procedure);
                } else {
                    graph.asyncRequest(this.labelQuery, procedure);
                }
            });
        }
        if (this.content == null) {
            return Collections.emptyMap();
        }
        return this.content.labels;
    }

    public Labeler.Modifier getModifier(final GraphExplorer.ModificationContext modificationContext, final String columnKey) {
        Object obj = this.context.getConstant(BuiltinKeys.INPUT);
        if (obj instanceof IModifiableNode) {
            return ((IModifiableNode)obj).getModifier(columnKey);
        }
        try {
            return (Labeler.Modifier)Simantics.getSession().syncRequest((Read)new Read<Labeler.Modifier>(){

                public Labeler.Modifier perform(ReadGraph graph) throws DatabaseException {
                    UndoContext undoContext = modificationContext == null ? null : (UndoContext)modificationContext.getAdapter(UndoContext.class);
                    return FinalLabelerContributionImpl.this.getModifier(graph, undoContext, FinalLabelerContributionImpl.this.context, columnKey);
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public boolean shouldCreateToolTip(Event event, NodeContext nodeContext) {
        return this.createToolTip(event, nodeContext);
    }

    public Composite createToolTipContentArea(Event event, Composite parent, NodeContext nodeContext) {
        return (Composite)this.createToolTipContent(event, parent, nodeContext);
    }

    public Labeler.Modifier getModifier(ReadGraph graph, UndoContext undoContext, NodeContext context, String columnKey) throws DatabaseException {
        return null;
    }

    public abstract Map<String, String> labels(ReadGraph var1, NodeContext var2) throws DatabaseException;

    public abstract int category(ReadGraph var1, NodeContext var2) throws DatabaseException;

    public boolean createToolTip(Object event, NodeContext nodeContext) {
        return false;
    }

    public Object createToolTipContent(Object event, Object parent, NodeContext nodeContext) {
        return null;
    }
}

