/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Map;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.labelers.LabelerContent;
import org.simantics.browsing.ui.common.labelers.LabelerStub;
import org.simantics.browsing.ui.graph.impl.request.ParametrizedResourceQuery;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;

public abstract class LazyParametrizedGraphLabeler
extends LabelerStub {
    private final ParametrizedResourceQuery<LabelerContent> labelQuery;
    private final Listener<LabelerContent> labelProcedure;
    private final PrimitiveQueryUpdater updater;
    static int debugCounter = 0;

    public LazyParametrizedGraphLabeler(final PrimitiveQueryUpdater updater, final NodeContext context, final BuiltinKeys.LabelerKey key, Object ... parameters) {
        this.updater = updater;
        this.labelQuery = new ParametrizedResourceQuery<LabelerContent>(((Object)((Object)this)).getClass(), context, parameters){

            public LabelerContent perform(ReadGraph graph) throws DatabaseException {
                return new LabelerContent(LazyParametrizedGraphLabeler.this.category(graph), LazyParametrizedGraphLabeler.this.labels(graph));
            }
        };
        this.labelProcedure = new Listener<LabelerContent>(){

            public void execute(LabelerContent result) {
                LazyParametrizedGraphLabeler.this.setContent(result);
                updater.scheduleReplace(context, (NodeContext.PrimitiveQueryKey)key, (Object)LazyParametrizedGraphLabeler.this);
            }

            public void exception(Throwable t) {
                t.printStackTrace();
            }

            public boolean isDisposed() {
                return updater.isDisposed();
            }
        };
    }

    public Map<String, String> getLabels() {
        if (this.content == LabelerContent.NO_CONTENT) {
            DataSource source = this.updater.getDataSource(ReadGraph.class);
            source.schedule(graph -> {
                try {
                    graph.syncRequest(this.labelQuery, this.labelProcedure);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            });
        }
        return this.content.labels;
    }

    public abstract Map<String, String> labels(ReadGraph var1) throws DatabaseException;

    public int category(ReadGraph graph) {
        return this.content.category;
    }
}

