/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Objects;
import org.simantics.browsing.ui.common.modifiers.AbstractEnumerationModifier;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;

public abstract class GraphEnumerationModifierBase<T>
extends AbstractEnumerationModifier<T> {
    protected final Session session;

    public GraphEnumerationModifierBase(Session session, Enumeration<T> enumeration, T value) {
        this(session, enumeration, enumeration.find(value));
    }

    public GraphEnumerationModifierBase(Session session, Enumeration<T> enumeration, EnumeratedValue<T> value) {
        super(enumeration, value);
        if (session == null) {
            throw new NullPointerException("null session");
        }
        this.session = session;
    }

    protected void modifyWithObject(final T oldEnumObject, final T enumObject) {
        if (Objects.equals(oldEnumObject, enumObject)) {
            return;
        }
        try {
            this.session.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    GraphEnumerationModifierBase.this.modifyWithObject(graph, oldEnumObject, enumObject);
                }
            });
        }
        catch (DatabaseException e) {
            this.handleException(e);
        }
    }

    protected abstract void modifyWithObject(WriteGraph var1, T var2, T var3) throws DatabaseException;

    protected void handleException(DatabaseException e) {
        throw new RuntimeException(e);
    }
}

