/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contributor.imager;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ImageDecoratorKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.content.ImageDecoratorFactory;
import org.simantics.browsing.ui.graph.impl.contribution.ImageDecoratorContributionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.ReflectionUtils;

/**
 * @author Tuukka Lehtonen
 *
 * @param <T>
 */
public abstract class ImageDecoratorContributorImpl<T> implements Contributor<ImageDecoratorFactory> {

    abstract public ImageDecorator getDecorator(ReadGraph graph, T input) throws DatabaseException;

    final private Class<?> clazz;

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

    public ImageDecoratorContributorImpl() {
        clazz = ReflectionUtils.getSingleParameterType(getClass());
    }

    public ImageDecoratorContributorImpl(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public ImageDecoratorFactory getFactory() {

        return new ImageDecoratorFactory() {

            @Override
            public ImageDecorator create(final PrimitiveQueryUpdater updater, NodeContext context, ImageDecoratorKey key) {

                return new ImageDecoratorContributionImpl(updater, context, key) {

                    @SuppressWarnings("unchecked")
                    @Override
                    public ImageDecorator getDecorator(ReadGraph graph, NodeContext context) throws DatabaseException {

                        T input = (T)context.getConstant(BuiltinKeys.INPUT);

                        return ImageDecoratorContributorImpl.this.getDecorator(graph, input);

                    }

                };

            }

        };

    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

}
