/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contribution;

import org.simantics.browsing.ui.BuiltinKeys.ImageDecoratorKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.utils.ui.ErrorLogger;

/**
 * Implement {@link #children(AsyncReadGraph)} and
 * {@link #hasChildren(AsyncReadGraph)}.
 * 
 * @author Tuukka Lehtonen
 */
abstract public class ImageDecoratorContributionImpl extends FinalImageDecoratorContributionImpl {

    public ImageDecoratorContributionImpl(PrimitiveQueryUpdater updater, NodeContext context, ImageDecoratorKey key) {
        super(updater, context, key);
    }

    @Override
    protected Procedure<ImageDecorator> createProcedure() {

        return new Listener<ImageDecorator>() {

    		boolean executed = false;
    		boolean disposed = false;
        	
            @Override
            public void execute(ImageDecorator result) {
                replaceResult(result);
                executed = true;
            }

            @Override
            public boolean isDisposed() {
            	
            	if(disposed) return true;

            	if((updater.isDisposed() || !updater.isShown(context)) && executed) {
            		decorator = FRESH;
            		disposed = true;
            		return true;
            	} else {
            		return false;
            	}
            	
            }

            @Override
            public void exception(Throwable t) {
                ErrorLogger.defaultLogError(
                        "ImageDecoratorContributionImpl.imageQuery failed, see exception for details.", t);
            }

        };

    }

}
