/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.eclipse.ui.IWorkbenchPart;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;

/**
 * @author Antti Villberg
 */
public class URIResourceInputSource implements SessionContextInputSource {

    final private String uri;

    public URIResourceInputSource(String uri) {
        this.uri = uri;
    }

    @Override
    public Object get(ISessionContext ctx) {
        if (ctx == null)
            return GraphExplorer.EMPTY_INPUT;

        try {
            return ctx.getSession().syncRequest(Queries.resource(uri));
        } catch (DatabaseException e) {
            ErrorLogger.defaultLogError(e);
            return GraphExplorer.EMPTY_INPUT;
        }
    }
    
    @Override
    public IWorkbenchPart getProvider() {
    	return null;
    }

}
