/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.common.property.IArrayProperty;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.utils.datastructures.slice.ValueRange;

/**
 * @author Tuukka Lehtonen
 */
public class ResourceArrayProperty extends ResourceProperty implements IArrayProperty {

    protected final ValueRange range;

    public ResourceArrayProperty(Type type, ValueRange range, Resource subject, Resource predicate, Resource value,
            ResourceArray path) {
        super(type, subject, predicate, value, path);
        if (range == null)
            throw new IllegalArgumentException("null value range");
        this.range = range;
    }

    @Override
    public ValueRange getRange() {
        return range;
    }

    @Override
    public String toString() {
        return super.toString() + "[range=" + range + "]";
    }

    @Override
    public int propertyHashCode() {
        return super.propertyHashCode() * 31 + range.hashCode();
    }

    @Override
    public boolean propertyEquals(Object obj) {
        if (this == obj)
            return true;
        if (!super.propertyEquals(obj))
            return false;
        ResourceArrayProperty other = (ResourceArrayProperty) obj;
        return range.equals(other.range);
    }

    @Override
    public int hashCode() {
        return range.hashCode() + 31 * super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!super.equals(obj))
            return false;
        ResourceArrayProperty other = (ResourceArrayProperty) obj;
        return range.equals(other.range);
    }

    @Override
    public IArrayProperty slice(ValueRange range) {
        return new SlicedResourceArrayProperty(type, range, subject, predicate, value, path);
    }

    @Override
    public boolean isSlice() {
        return false;
    }

    private static class SlicedResourceArrayProperty extends ResourceArrayProperty {
        public SlicedResourceArrayProperty(Type type, ValueRange range, Resource subject, Resource predicate,
                Resource value, ResourceArray path) {
            super(type, range, subject, predicate, value, path);
        }
        @Override
        public boolean isSlice() {
            return true;
        }
    }

}
