/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Map;

import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;
import org.simantics.browsing.ui.GraphExplorer.ModificationContext;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.modifiers.EnumerationValue;
import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.datastructures.ArrayMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Requires {@link IProperty} as input.
 * 
 * @author Tuukka Lehtonen
 */
public class PropertyValueRepresentationLabelerFactory implements LabelerFactory {

    @Override
    public Labeler create(PrimitiveQueryUpdater manager, final NodeContext context, LabelerKey key) {
        assert(manager != null);
        assert(context != null);

        return new LazyGraphLabeler(manager, context, key) {
            @Override
            public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
                IProperty prop = (IProperty) context.getConstant(BuiltinKeys.INPUT);
                Resource[] r = prop.adapt(Resource[].class);

                String property = LabelerUtil.safeStringRepresentation(graph, r[1]);
                String value = LabelerUtil.safeStringRepresentation(graph, r[2]);

                return new ArrayMap<String, String>(ColumnKeys.KEYS_PROPERTY_VALUE, new String[] { property, value });
            }

            @Override
            public Modifier getModifier(ModificationContext modificationContext, String key) {
                ISessionContext session = Simantics.getSessionContext();
                if (session == null)
                    return null;

                IProperty prop = (IProperty) context.getConstant(BuiltinKeys.INPUT);
                Resource[] r = prop.adapt(Resource[].class);

                if (ColumnKeys.VALUE.equals(key)) {
                    try {
                        EnumerationValue<Resource> enu = session.getSession().syncRequest(new GetEnumerationValue(r[2]));
                        if (enu != null) {
                            return new GraphEnumerationModifier(session.getSession(), r[0], r[1], enu.getEnumeration(), enu.getEnumeratedValue());
                        } else {
                            return new GraphFactoryStringModifier(r[0], r[1], r[2], session.getSession());
                        }
                    } catch (DatabaseException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
            
            @Override
            public Logger getLogger() {
                return LoggerFactory.getLogger(getClass());
            }

        };
    }

}
