/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;

/**
 * A basic viewpoint factory for IArrayProperty implementations.
 * 
 * @author Tuukka Lehtonen
 * @see PropertyViewpointFactory one originator for IArrayProperty instances
 */
public class ArrayPropertyValueViewpointFactory implements ViewpointFactory {

    @Override
    public Viewpoint create(PrimitiveQueryUpdater updater, final NodeContext context, ViewpointKey key) {
        return new ArrayPropertyViewpoint(updater, context, key);
    }

    @Override
    public String toString() {
        return "Property value";
    }

}
