/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.SelectionRequest;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.processors.AbstractNodeQueryProcessor;
import org.simantics.browsing.ui.content.PrunedChildrenResult;
import org.simantics.browsing.ui.content.ViewpointContribution;

public class DefaultPrunedChildrenProcessor
extends AbstractNodeQueryProcessor<PrunedChildrenResult> {
    public NodeContext.QueryKey<PrunedChildrenResult> getIdentifier() {
        return BuiltinKeys.PRUNED_CHILDREN;
    }

    public PrunedChildrenResult query(NodeQueryManager manager, NodeContext context) {
        Collection contributions = (Collection)manager.query(context, BuiltinKeys.VIEWPOINT_CONTRIBUTIONS);
        if (contributions == null) {
            return PrunedChildrenResult.EMPTY;
        }
        HashSet<NodeContext> childSet = new HashSet<NodeContext>();
        ArrayList<NodeContext> children = new ArrayList<NodeContext>();
        for (ViewpointContribution contribution : contributions) {
            Tester test;
            Class clazz = contribution.getInputClass();
            if (!clazz.isInstance(context.getConstant(BuiltinKeys.INPUT)) || (test = contribution.getNodeContextTester()) != null && !test.test(manager, context)) continue;
            Collection contrib = contribution.getContribution();
            children.ensureCapacity(children.size() + contrib.size());
            for (NodeContext nc : contrib) {
                if (!childSet.add(nc)) continue;
                children.add(nc);
            }
        }
        Collection selectionRequests = (Collection)manager.query(context, BuiltinKeys.SELECTION_REQUESTS);
        if (selectionRequests == null) {
            return new PrunedChildrenResult(children.size(), children.toArray(NodeContext.NONE));
        }
        SelectionRequest[] reqs = selectionRequests.toArray(new SelectionRequest[selectionRequests.size()]);
        ArrayList<NodeContext> pruned = new ArrayList<NodeContext>();
        for (NodeContext ctx : children) {
            boolean add = true;
            if (selectionRequests != null) {
                SelectionRequest[] selectionRequestArray = reqs;
                int n = reqs.length;
                int n2 = 0;
                while (n2 < n) {
                    SelectionRequest req = selectionRequestArray[n2];
                    if (req.getRequest() == SelectionRequest.Request.FILTER && req.isIncluded(manager, (Object)ctx)) {
                        add = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (!add) continue;
            pruned.add(ctx);
        }
        return new PrunedChildrenResult(children.size(), pruned.toArray(NodeContext.NONE));
    }

    @Override
    public String toString() {
        return "PrunedChildrenProcessor";
    }
}

