/*******************************************************************************
 * Copyright (c) 2012, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.state;

import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;

/**
 * @author Antti Villberg
 */
public class GraphExplorerStateBean extends Bean {
	private static final Binding BINDING = Bindings.getBindingUnchecked(GraphExplorerStateBean.class);

	public GraphExplorerStateBean() {
		super(BINDING);
	}

	public GraphExplorerStateNodeBean[] topNodePath;
	public int[]                        topNodePathChildIndexes;
	public GraphExplorerStateNodeBean[] expandedNodes;
	public Map<String, Integer>         columnWidths;
}
