/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.property;

import java.util.EnumSet;

import org.eclipse.core.runtime.IAdaptable;


/**
 * @author Tuukka Lehtonen
 */
public interface IProperty extends IAdaptable, PropertyComparable {

    enum Type {
        DIRECT,
        ASSERTED,
    }

    EnumSet<Type> DIRECT   = EnumSet.of(Type.DIRECT);
    EnumSet<Type> ASSERTED = EnumSet.of(Type.ASSERTED);

    /**
     * @return
     */
    Type getType();

    /**
     * @return
     */
    <T> T getData(Class<T> clazz);

    /**
     * @param <T>
     * @param clazz
     * @return
     */
    <T> T adapt(Class<T> clazz);

}
