/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.internal;

import gnu.trove.set.hash.THashSet;

import java.util.Collection;
import java.util.Set;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.CacheKey;

public interface IGECache {

    interface IGECacheEntry {
        Object getValue();
        void setValue(Object value);
//        Collection<NodeQueryUpdater> getDependencies();
//        void addDependency(NodeQueryUpdater caller);
        NodeContext getContext();
        CacheKey<?> getKey();
        Collection<IGECacheEntry> getDependencies();
        void addDependency(IGECacheEntry caller);
        void reset();
    }

    class GECacheEntry implements IGECacheEntry {

        private Object result;
        final private NodeContext context;
        final private CacheKey<?> key;
        private Set<IGECacheEntry> callers = new THashSet<IGECacheEntry>(2);

        public <T> GECacheEntry(NodeContext context, CacheKey<T> key, T result) {
            this.context = context;
            this.key = key;
            this.result = result;
        }
        @Override
        public Collection<IGECacheEntry> getDependencies() {
            return callers;
        }
        @Override
        public Object getValue() {
            return result;
        }
        @Override
        public void addDependency(IGECacheEntry caller) {
            assert(caller != null);
            callers.add(caller);
        }
        @Override
        public void setValue(Object value) {
            result = value;
        }
        @Override
        public NodeContext getContext() {
            return context;
        }
        @Override
        public CacheKey<?> getKey() {
            return key;
        }
        @Override
        public void reset() {
            callers = new THashSet<IGECacheEntry>(2);
        }

        @Override
        public int hashCode() {
            return 31 * context.hashCode() | key.hashCode();
        }

        @Override
        public boolean equals(Object object) {

            if (this == object)
                return true;
            else if (object == null)
                return false;
            else if (getClass() != object.getClass())
                return false;

            GECacheEntry i = (GECacheEntry)object;

            return key.equals(i.key) && context.equals(i.context);

        }

//        @Override
//        public String toString() {
//            return "GECacheEntry[" + result + ", " + context + ", " + key + "]";
//        }

    }

    <T> IGECacheEntry getEntry(NodeContext context, CacheKey<T> key);

    <T> IGECacheEntry put(NodeContext context, CacheKey<T> key, T value);
    <T> void putTreeReference(NodeContext context, CacheKey<T> key, UIElementReference reference);

    <T> T get(NodeContext context, CacheKey<T> key);
    <T> Set<UIElementReference> getTreeReference(NodeContext context, CacheKey<T> key);

    <T> void remove(NodeContext context, CacheKey<T> key);
    <T> Set<UIElementReference> removeTreeReference(NodeContext context, CacheKey<T> key);
    
    boolean isShown(NodeContext context);
    void incRef(NodeContext context);
    void decRef(NodeContext context);
    
    void dispose();
}
