/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.contributor;

import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.BuiltinKeys.ViewpointContributionKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.content.ViewpointContribution;
import org.simantics.browsing.ui.content.ViewpointContributionFactory;
import org.simantics.utils.ReflectionUtils;

/**
 * @author Antti Villberg
 *
 * @param <T> the input type accepted by this contributor
 */
public abstract class AbstractViewpointContributionContributor<T> implements Contributor<ViewpointContributionFactory> {

    private final Class<?> clazz;

    public AbstractViewpointContributionContributor() {
    	clazz = ReflectionUtils.getSingleParameterType(getClass());
    }

    public AbstractViewpointContributionContributor(Class<?> clazz) {
    	this.clazz = clazz;
    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

    @Override
    public ViewpointContributionFactory getFactory() {

        return new ViewpointContributionFactory() {

            @Override
            public ViewpointContribution create(final PrimitiveQueryUpdater updater,
                    final NodeContext context, final ViewpointContributionKey key) {

                return new ViewpointContribution() {

                	Collection<NodeContext> contribution = Collections.emptySet();
                	
                	@Override
                	public Collection<NodeContext> getContribution() {

                		Collection<NodeContext> current = AbstractViewpointContributionContributor.this.getContribution(updater, context, key); 

                		for(NodeContext c : current) updater.incRef(c);
                		for(NodeContext c : contribution) updater.decRef(c);
                		contribution = current;

                		return current;
                		
                	}

                    public boolean hasChildren() {
                        Collection<NodeContext> current = AbstractViewpointContributionContributor.this.getContribution(updater, context, key); 
                        return current.size() > 0;
                    }

                    @Override
                    public Class<?> getInputClass() {
                        return clazz;
                    }

                    @Override
                    public Tester getNodeContextTester() {
                        return AbstractViewpointContributionContributor.this.getNodeContextTester();
                    }

                };

            }

            @Override
            public String getViewpointId() {
                return AbstractViewpointContributionContributor.this.getViewpointId();
            }

        };

    }

    abstract public Collection<NodeContext> getContribution(PrimitiveQueryUpdater updater,
            NodeContext context, ViewpointContributionKey key);

    abstract public String getViewpointId();

}
