/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.application.arguments;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.simantics.application.arguments.Arguments;
import org.simantics.application.arguments.IArgumentFactory;
import org.simantics.application.arguments.IArguments;
import org.simantics.application.internal.Activator;

public class ApplicationUtils {
    public static void loadSystemProperties(URL props) {
        if (props != null) {
            InputStream in = null;
            try {
                try {
                    in = props.openStream();
                    System.getProperties().load(in);
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.simantics.application", "Failed to load system properties: " + String.valueOf(props), (Throwable)e));
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e2) {
                        Activator.getDefault().getLog().log((IStatus)new Status(2, "org.simantics.application", "Failed to close system properties: " + String.valueOf(props), (Throwable)e2));
                    }
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.simantics.application", "Failed to close system properties: " + String.valueOf(props), (Throwable)e));
                }
            }
        }
    }

    public static String[] decodePath(String dottedPath) {
        if (dottedPath == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int index = 0;
        while (dottedPath.length() > 0) {
            int dotIndex = dottedPath.indexOf(".", index);
            if (dotIndex < 0) {
                if (dottedPath.length() <= 0) break;
                result.add(dottedPath.replace("\\.", "."));
                break;
            }
            if (dotIndex > 0 && dottedPath.charAt(dotIndex - 1) == '\\') {
                index = dotIndex + 1;
                continue;
            }
            String pathPart = dottedPath.substring(0, dotIndex);
            result.add(pathPart.replace("\\.", "."));
            dottedPath = dottedPath.substring(dotIndex + 1);
            index = 0;
        }
        return result.toArray(new String[result.size()]);
    }

    public static String encodePath(String[] namePath) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        String[] stringArray = namePath;
        int n = namePath.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!first) {
                b.append('.');
            }
            first = false;
            b.append(s.replace(".", "\\."));
            ++n2;
        }
        return b.toString();
    }

    public static IArguments parseApplicationArguments(IArgumentFactory<?> ... accepted) {
        return Arguments.parse(Platform.getApplicationArgs(), accepted);
    }
}

