/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.annotation.ui.actions;

import org.simantics.Simantics;
import org.simantics.annotation.ui.AnnotationUtils;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.utils.ui.ErrorLogger;

public class NewAnnotation implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource parent = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                try {
                    Resource model = Simantics.getSession().syncRequest(new PossibleIndexRoot(parent));
                    if(model == null) return;
                    Simantics.getSession().markUndoPoint();
                    AnnotationUtils.newAnnotation(parent, model);
                } catch (DatabaseException e) {
                    ErrorLogger.defaultLogError(e);
                }
            }
        };
    }

}
