package org.simantics.annotation.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class AnnotationResource {
    
    public final Resource Actions;
    public final Resource Actions_AnnotationDropAction;
    public final Resource Actions_NewAnnotation;
    public final Resource Actions_NewAnnotationInstance;
    public final Resource Actions_NewAnnotationType;
    public final Resource Actions_NoActionCategory;
    public final Resource Annotation;
    public final Resource AnnotationAC;
    public final Resource AnnotationBC;
    public final Resource AnnotationBC_AnnotationTypeLabelRule;
    public final Resource AnnotationBC_AnnotationTypeModifierRule;
    public final Resource AnnotationBC_IsUserAnnotationTest;
    public final Resource AnnotationType;
    @Deprecated public final Resource AnnotationTypeLibrary;
    @Deprecated public final Resource AnnotationTypeLibraryUI;
    @Deprecated public final Resource AnnotationTypeUI;
    public final Resource AnnotationType_systemAnnotation;
    public final Resource AnnotationType_systemAnnotation_Inverse;
    @Deprecated public final Resource AnnotationUI;
    public final Resource Annotation_HasEntry;
    public final Resource Annotation_HasEntry_Inverse;
    @Deprecated public final Resource BrowseNode;
    public final Resource DefaultAnnotationSource;
    public final Resource Functions;
    public final Resource Functions_availableAnnotations;
    public final Resource Functions_availableSources;
    public final Resource Functions_descriptionText;
    public final Resource Functions_domainChildren;
    public final Resource Functions_explorerInput;
    public final Resource Functions_explorerInput2;
    public final Resource Functions_newAnnotationModifier;
    public final Resource Functions_removeAnnotationModifier;
    public final Resource Functions_saveAnnotationModifier;
    public final Resource Functions_selectedAnnotation;
    public final Resource Functions_selectedAnnotationModifier;
    public final Resource Functions_selectedSource;
    public final Resource Functions_selectedSourceModifier;
    public final Resource HasAnnotationPropertySubrelation;
    @Deprecated public final Resource HasAnnotationTypeRoot;
    public final Resource HasAnnotationTypeRoot_Inverse;
    public final Resource HasAnnotationTypeSupertype;
    public final Resource HasDefaultAnnotationName;
    public final Resource HasDefaultAnnotationType;
    public final Resource Images;
    public final Resource Images_Annotation;
    public final Resource Images_AnnotationType;
    public final Resource Images_General;
    public final Resource SelectionTab;
    public final Resource SelectionTab2;
    public final Resource SelectionTab2_Properties;
    public final Resource SelectionTabContribution;
    public final Resource SelectionTabContribution2;
    public final Resource SelectionTab_Add;
    public final Resource SelectionTab_BC;
    public final Resource SelectionTab_Combo1;
    public final Resource SelectionTab_Combo2;
    public final Resource SelectionTab_Description;
    public final Resource SelectionTab_Properties;
    public final Resource SelectionTab_Remove;
    public final Resource SelectionTab_Save;
        
    public static class URIs {
        public static final String Actions = "http://www.simantics.org/Annotation-1.0/Actions";
        public static final String Actions_AnnotationDropAction = "http://www.simantics.org/Annotation-1.0/Actions/AnnotationDropAction";
        public static final String Actions_NewAnnotation = "http://www.simantics.org/Annotation-1.0/Actions/NewAnnotation";
        public static final String Actions_NewAnnotationInstance = "http://www.simantics.org/Annotation-1.0/Actions/NewAnnotationInstance";
        public static final String Actions_NewAnnotationType = "http://www.simantics.org/Annotation-1.0/Actions/NewAnnotationType";
        public static final String Actions_NoActionCategory = "http://www.simantics.org/Annotation-1.0/Actions/NoActionCategory";
        public static final String Annotation = "http://www.simantics.org/Annotation-1.0/Annotation";
        public static final String AnnotationAC = "http://www.simantics.org/Annotation-1.0/AnnotationAC";
        public static final String AnnotationBC = "http://www.simantics.org/Annotation-1.0/AnnotationBC";
        public static final String AnnotationBC_AnnotationTypeLabelRule = "http://www.simantics.org/Annotation-1.0/AnnotationBC/AnnotationTypeLabelRule";
        public static final String AnnotationBC_AnnotationTypeModifierRule = "http://www.simantics.org/Annotation-1.0/AnnotationBC/AnnotationTypeModifierRule";
        public static final String AnnotationBC_IsUserAnnotationTest = "http://www.simantics.org/Annotation-1.0/AnnotationBC/IsUserAnnotationTest";
        public static final String AnnotationType = "http://www.simantics.org/Annotation-1.0/AnnotationType";
        @Deprecated public static final String AnnotationTypeLibrary = "http://www.simantics.org/Annotation-1.0/AnnotationTypeLibrary";
        @Deprecated public static final String AnnotationTypeLibraryUI = "http://www.simantics.org/Annotation-1.0/AnnotationTypeLibraryUI";
        @Deprecated public static final String AnnotationTypeUI = "http://www.simantics.org/Annotation-1.0/AnnotationTypeUI";
        public static final String AnnotationType_systemAnnotation = "http://www.simantics.org/Annotation-1.0/AnnotationType/systemAnnotation";
        public static final String AnnotationType_systemAnnotation_Inverse = "http://www.simantics.org/Annotation-1.0/AnnotationType/systemAnnotation/Inverse";
        @Deprecated public static final String AnnotationUI = "http://www.simantics.org/Annotation-1.0/AnnotationUI";
        public static final String Annotation_HasEntry = "http://www.simantics.org/Annotation-1.0/Annotation/HasEntry";
        public static final String Annotation_HasEntry_Inverse = "http://www.simantics.org/Annotation-1.0/Annotation/HasEntry/Inverse";
        @Deprecated public static final String BrowseNode = "http://www.simantics.org/Annotation-1.0/BrowseNode";
        public static final String DefaultAnnotationSource = "http://www.simantics.org/Annotation-1.0/DefaultAnnotationSource";
        public static final String Functions = "http://www.simantics.org/Annotation-1.0/Functions";
        public static final String Functions_availableAnnotations = "http://www.simantics.org/Annotation-1.0/Functions/availableAnnotations";
        public static final String Functions_availableSources = "http://www.simantics.org/Annotation-1.0/Functions/availableSources";
        public static final String Functions_descriptionText = "http://www.simantics.org/Annotation-1.0/Functions/descriptionText";
        public static final String Functions_domainChildren = "http://www.simantics.org/Annotation-1.0/Functions/domainChildren";
        public static final String Functions_explorerInput = "http://www.simantics.org/Annotation-1.0/Functions/explorerInput";
        public static final String Functions_explorerInput2 = "http://www.simantics.org/Annotation-1.0/Functions/explorerInput2";
        public static final String Functions_newAnnotationModifier = "http://www.simantics.org/Annotation-1.0/Functions/newAnnotationModifier";
        public static final String Functions_removeAnnotationModifier = "http://www.simantics.org/Annotation-1.0/Functions/removeAnnotationModifier";
        public static final String Functions_saveAnnotationModifier = "http://www.simantics.org/Annotation-1.0/Functions/saveAnnotationModifier";
        public static final String Functions_selectedAnnotation = "http://www.simantics.org/Annotation-1.0/Functions/selectedAnnotation";
        public static final String Functions_selectedAnnotationModifier = "http://www.simantics.org/Annotation-1.0/Functions/selectedAnnotationModifier";
        public static final String Functions_selectedSource = "http://www.simantics.org/Annotation-1.0/Functions/selectedSource";
        public static final String Functions_selectedSourceModifier = "http://www.simantics.org/Annotation-1.0/Functions/selectedSourceModifier";
        public static final String HasAnnotationPropertySubrelation = "http://www.simantics.org/Annotation-1.0/HasAnnotationPropertySubrelation";
        @Deprecated public static final String HasAnnotationTypeRoot = "http://www.simantics.org/Annotation-1.0/HasAnnotationTypeRoot";
        public static final String HasAnnotationTypeRoot_Inverse = "http://www.simantics.org/Annotation-1.0/HasAnnotationTypeRoot/Inverse";
        public static final String HasAnnotationTypeSupertype = "http://www.simantics.org/Annotation-1.0/HasAnnotationTypeSupertype";
        public static final String HasDefaultAnnotationName = "http://www.simantics.org/Annotation-1.0/HasDefaultAnnotationName";
        public static final String HasDefaultAnnotationType = "http://www.simantics.org/Annotation-1.0/HasDefaultAnnotationType";
        public static final String Images = "http://www.simantics.org/Annotation-1.0/Images";
        public static final String Images_Annotation = "http://www.simantics.org/Annotation-1.0/Images/Annotation";
        public static final String Images_AnnotationType = "http://www.simantics.org/Annotation-1.0/Images/AnnotationType";
        public static final String Images_General = "http://www.simantics.org/Annotation-1.0/Images/General";
        public static final String SelectionTab = "http://www.simantics.org/Annotation-1.0/SelectionTab";
        public static final String SelectionTab2 = "http://www.simantics.org/Annotation-1.0/SelectionTab2";
        public static final String SelectionTab2_Properties = "http://www.simantics.org/Annotation-1.0/SelectionTab2/Properties";
        public static final String SelectionTabContribution = "http://www.simantics.org/Annotation-1.0/SelectionTabContribution";
        public static final String SelectionTabContribution2 = "http://www.simantics.org/Annotation-1.0/SelectionTabContribution2";
        public static final String SelectionTab_Add = "http://www.simantics.org/Annotation-1.0/SelectionTab/Add";
        public static final String SelectionTab_BC = "http://www.simantics.org/Annotation-1.0/SelectionTab/BC";
        public static final String SelectionTab_Combo1 = "http://www.simantics.org/Annotation-1.0/SelectionTab/Combo1";
        public static final String SelectionTab_Combo2 = "http://www.simantics.org/Annotation-1.0/SelectionTab/Combo2";
        public static final String SelectionTab_Description = "http://www.simantics.org/Annotation-1.0/SelectionTab/Description";
        public static final String SelectionTab_Properties = "http://www.simantics.org/Annotation-1.0/SelectionTab/Properties";
        public static final String SelectionTab_Remove = "http://www.simantics.org/Annotation-1.0/SelectionTab/Remove";
        public static final String SelectionTab_Save = "http://www.simantics.org/Annotation-1.0/SelectionTab/Save";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public AnnotationResource(ReadGraph graph) {
        Actions = getResourceOrNull(graph, URIs.Actions);
        Actions_AnnotationDropAction = getResourceOrNull(graph, URIs.Actions_AnnotationDropAction);
        Actions_NewAnnotation = getResourceOrNull(graph, URIs.Actions_NewAnnotation);
        Actions_NewAnnotationInstance = getResourceOrNull(graph, URIs.Actions_NewAnnotationInstance);
        Actions_NewAnnotationType = getResourceOrNull(graph, URIs.Actions_NewAnnotationType);
        Actions_NoActionCategory = getResourceOrNull(graph, URIs.Actions_NoActionCategory);
        Annotation = getResourceOrNull(graph, URIs.Annotation);
        AnnotationAC = getResourceOrNull(graph, URIs.AnnotationAC);
        AnnotationBC = getResourceOrNull(graph, URIs.AnnotationBC);
        AnnotationBC_AnnotationTypeLabelRule = getResourceOrNull(graph, URIs.AnnotationBC_AnnotationTypeLabelRule);
        AnnotationBC_AnnotationTypeModifierRule = getResourceOrNull(graph, URIs.AnnotationBC_AnnotationTypeModifierRule);
        AnnotationBC_IsUserAnnotationTest = getResourceOrNull(graph, URIs.AnnotationBC_IsUserAnnotationTest);
        AnnotationType = getResourceOrNull(graph, URIs.AnnotationType);
        AnnotationTypeLibrary = getResourceOrNull(graph, URIs.AnnotationTypeLibrary);
        AnnotationTypeLibraryUI = getResourceOrNull(graph, URIs.AnnotationTypeLibraryUI);
        AnnotationTypeUI = getResourceOrNull(graph, URIs.AnnotationTypeUI);
        AnnotationType_systemAnnotation = getResourceOrNull(graph, URIs.AnnotationType_systemAnnotation);
        AnnotationType_systemAnnotation_Inverse = getResourceOrNull(graph, URIs.AnnotationType_systemAnnotation_Inverse);
        AnnotationUI = getResourceOrNull(graph, URIs.AnnotationUI);
        Annotation_HasEntry = getResourceOrNull(graph, URIs.Annotation_HasEntry);
        Annotation_HasEntry_Inverse = getResourceOrNull(graph, URIs.Annotation_HasEntry_Inverse);
        BrowseNode = getResourceOrNull(graph, URIs.BrowseNode);
        DefaultAnnotationSource = getResourceOrNull(graph, URIs.DefaultAnnotationSource);
        Functions = getResourceOrNull(graph, URIs.Functions);
        Functions_availableAnnotations = getResourceOrNull(graph, URIs.Functions_availableAnnotations);
        Functions_availableSources = getResourceOrNull(graph, URIs.Functions_availableSources);
        Functions_descriptionText = getResourceOrNull(graph, URIs.Functions_descriptionText);
        Functions_domainChildren = getResourceOrNull(graph, URIs.Functions_domainChildren);
        Functions_explorerInput = getResourceOrNull(graph, URIs.Functions_explorerInput);
        Functions_explorerInput2 = getResourceOrNull(graph, URIs.Functions_explorerInput2);
        Functions_newAnnotationModifier = getResourceOrNull(graph, URIs.Functions_newAnnotationModifier);
        Functions_removeAnnotationModifier = getResourceOrNull(graph, URIs.Functions_removeAnnotationModifier);
        Functions_saveAnnotationModifier = getResourceOrNull(graph, URIs.Functions_saveAnnotationModifier);
        Functions_selectedAnnotation = getResourceOrNull(graph, URIs.Functions_selectedAnnotation);
        Functions_selectedAnnotationModifier = getResourceOrNull(graph, URIs.Functions_selectedAnnotationModifier);
        Functions_selectedSource = getResourceOrNull(graph, URIs.Functions_selectedSource);
        Functions_selectedSourceModifier = getResourceOrNull(graph, URIs.Functions_selectedSourceModifier);
        HasAnnotationPropertySubrelation = getResourceOrNull(graph, URIs.HasAnnotationPropertySubrelation);
        HasAnnotationTypeRoot = getResourceOrNull(graph, URIs.HasAnnotationTypeRoot);
        HasAnnotationTypeRoot_Inverse = getResourceOrNull(graph, URIs.HasAnnotationTypeRoot_Inverse);
        HasAnnotationTypeSupertype = getResourceOrNull(graph, URIs.HasAnnotationTypeSupertype);
        HasDefaultAnnotationName = getResourceOrNull(graph, URIs.HasDefaultAnnotationName);
        HasDefaultAnnotationType = getResourceOrNull(graph, URIs.HasDefaultAnnotationType);
        Images = getResourceOrNull(graph, URIs.Images);
        Images_Annotation = getResourceOrNull(graph, URIs.Images_Annotation);
        Images_AnnotationType = getResourceOrNull(graph, URIs.Images_AnnotationType);
        Images_General = getResourceOrNull(graph, URIs.Images_General);
        SelectionTab = getResourceOrNull(graph, URIs.SelectionTab);
        SelectionTab2 = getResourceOrNull(graph, URIs.SelectionTab2);
        SelectionTab2_Properties = getResourceOrNull(graph, URIs.SelectionTab2_Properties);
        SelectionTabContribution = getResourceOrNull(graph, URIs.SelectionTabContribution);
        SelectionTabContribution2 = getResourceOrNull(graph, URIs.SelectionTabContribution2);
        SelectionTab_Add = getResourceOrNull(graph, URIs.SelectionTab_Add);
        SelectionTab_BC = getResourceOrNull(graph, URIs.SelectionTab_BC);
        SelectionTab_Combo1 = getResourceOrNull(graph, URIs.SelectionTab_Combo1);
        SelectionTab_Combo2 = getResourceOrNull(graph, URIs.SelectionTab_Combo2);
        SelectionTab_Description = getResourceOrNull(graph, URIs.SelectionTab_Description);
        SelectionTab_Properties = getResourceOrNull(graph, URIs.SelectionTab_Properties);
        SelectionTab_Remove = getResourceOrNull(graph, URIs.SelectionTab_Remove);
        SelectionTab_Save = getResourceOrNull(graph, URIs.SelectionTab_Save);
    }
    
    public static AnnotationResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        AnnotationResource ret = session.peekService(AnnotationResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new AnnotationResource(qc.getIndependentGraph(graph));
            session.registerService(AnnotationResource.class, ret);
        }
        return ret;
    }
    
    public static AnnotationResource getInstance(RequestProcessor session) throws DatabaseException {
        AnnotationResource ret = session.peekService(AnnotationResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<AnnotationResource>() {
                public AnnotationResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new AnnotationResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(AnnotationResource.class, ret);
        }
        return ret;
    }
    
}

