/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.IOException;
import java.util.Objects;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.simantics.acorn.AcornKey;
import org.simantics.acorn.RocksIO;
import org.simantics.acorn.RocksStore;
import org.simantics.db.IO;

public class AcornKeyRocks
implements AcornKey {
    private RocksStore store;
    private AcornKeyRocks parent;
    private String name;

    public AcornKeyRocks(RocksStore store, AcornKeyRocks parent, String name) {
        this.store = store;
        this.parent = parent;
        this.name = name;
    }

    @Override
    public IO getIO() {
        return new RocksIO(this.store.db(), this);
    }

    public String key() {
        if (this.parent != null) {
            return this.parent.name + "." + this.name;
        }
        return "$" + this.name;
    }

    public byte[] keyBytes() {
        return this.key().getBytes();
    }

    @Override
    public boolean exists() throws IOException {
        try {
            return this.getIO().length() != 0L;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String debugLocation() {
        return this.key();
    }

    @Override
    public AcornKey child(String name) {
        return new AcornKeyRocks(this.store, this, name);
    }

    @Override
    public void ensureExists() throws IOException {
        byte[] MAGIC = "dir".getBytes();
        this.getIO().saveBytes(MAGIC, MAGIC.length, true);
    }

    @Override
    public boolean sameName(String n) {
        return this.name.equals(n);
    }

    @Override
    public void deleteIfExists() throws IOException {
        try {
            byte[] key = this.keyBytes();
            this.store.db().deleteRange(key, key);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int countChildren() throws IOException {
        RocksIterator it = this.store.db().newIterator();
        String prefix = this.name + ".";
        it.seek(prefix.getBytes());
        int count = 0;
        while (it.isValid()) {
            String key = new String(it.key());
            if (!key.startsWith(prefix)) break;
            ++count;
            it.next();
        }
        return count;
    }

    @Override
    public void sync() throws IOException {
    }

    @Override
    public void syncChildren() throws IOException {
    }

    @Override
    public void copyTo(AcornKey to) throws IOException {
        try {
            RocksIO io = (RocksIO)this.getIO();
            byte[] bytes = io.readFully();
            IO target = to.getIO();
            target.saveBytes(bytes, bytes.length, true);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteAll() throws IOException {
        try {
            RocksIterator it = this.store.db().newIterator();
            String prefix = this.name + ".";
            it.seek(prefix.getBytes());
            while (it.isValid()) {
                String key = new String(it.key());
                if (key.startsWith(prefix)) {
                    byte[] keyBytes = key.getBytes();
                    this.store.db().deleteRange(keyBytes, keyBytes);
                    it.next();
                    continue;
                }
                break;
            }
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent, this.store);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AcornKeyRocks other = (AcornKeyRocks)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.parent, other.parent) && Objects.equals(this.store, other.store);
    }
}

