package org.simantics.acorn;

import java.util.HashMap;
import java.util.Map;

import org.simantics.db.Disposable;
import org.simantics.db.IO;

/**
 * @author Tuukka Lehtonen
 * @since 1.32.0
 */
public class FileCache implements Disposable {

	private Map<AcornKey, IO> map = new HashMap<>();

	public IO get(AcornKey path) {
		synchronized (map) {
			return map.computeIfAbsent(path, p -> p.getIO());
		}
	}

	@Override
	public void dispose() {
		map = new HashMap<>();
	}

}
