/*******************************************************************************
 * Copyright (c) 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.acorn;

import java.io.IOException;
import java.io.OutputStream;

import org.simantics.db.IO;

/**
 * @author Antti Villberg
 */
public interface AcornKey {

	IO getIO();

	public boolean exists() throws IOException;

	public String getName();

	String debugLocation();

	AcornKey child(String name);
	
	void ensureExists() throws IOException;

	public boolean sameName(String n);

	public void deleteIfExists() throws IOException;

	int countChildren() throws IOException;

	public void sync() throws IOException;
	public void syncChildren() throws IOException;

	void copyTo(AcornKey to) throws IOException;

	public void deleteAll() throws IOException;
	
	default public byte[] bytes() throws IOException {
		IO io = getIO();
		return io.readBytes(0, (int)io.length());
	}
	
}