/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.ext;

import gnu.trove.ext.HashBase;
import java.util.function.Predicate;

public final class IdentityHashSet<T>
extends HashBase<T> {
    public IdentityHashSet(int initialCapacity, Class<T> clazz, T REMOVED) {
        super(initialCapacity, clazz, REMOVED);
    }

    protected final int insertionIndex(T obj) {
        Object[] set = this._set;
        int length = set.length;
        int hash = System.identityHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != this.REMOVED && cur == obj) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != this.REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && cur != this.REMOVED && cur != obj);
        }
        if (cur == this.REMOVED) {
            int firstRemoved = index;
            while (cur != null && (cur == this.REMOVED || cur != obj)) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }

    public final boolean add(T obj) {
        int index = this.insertionIndex(obj);
        if (index < 0) {
            return false;
        }
        Object old = this._set[index];
        this._set[index] = obj;
        this.postInsertHook(old == null);
        return true;
    }

    protected final void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldSet = this._set;
        this._set = this.createArray(newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == null || oldSet[i] == this.REMOVED) continue;
            Object o = oldSet[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
        }
    }

    protected final int index(Object obj) {
        Object[] set = this._set;
        int length = set.length;
        int hash = System.identityHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == null) {
            return -1;
        }
        if (cur == this.REMOVED || cur != obj) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == this.REMOVED || cur != obj));
        }
        return cur == null ? -1 : index;
    }

    public final boolean remove(Object obj) {
        int index = this.index(obj);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public final T removeOrGetByPredicate(Predicate<T> predicate) {
        this.tempDisableAutoCompaction();
        try {
            int i = 0;
            while (i < this._set.length) {
                Object entry = this._set[i];
                if (entry != null && this.REMOVED != entry) {
                    if (!predicate.test(entry)) {
                        Object object = entry;
                        return (T)object;
                    }
                    this.removeAt(i);
                }
                ++i;
            }
            return null;
        }
        finally {
            this.reenableAutoCompaction(false);
        }
    }

    public final T first() {
        int i = 0;
        while (i < this._set.length) {
            Object entry = this._set[i];
            if (entry != null && this.REMOVED != entry) {
                return (T)entry;
            }
            ++i;
        }
        return null;
    }

    public final T firstBy(Predicate<T> predicate) {
        int i = 0;
        while (i < this._set.length) {
            Object entry = this._set[i];
            if (entry != null && this.REMOVED != entry && predicate.test(entry)) {
                return (T)entry;
            }
            ++i;
        }
        return null;
    }

    public final int removeBy(Predicate<T> predicate) {
        this.tempDisableAutoCompaction();
        int size = 0;
        try {
            int i = 0;
            while (i < this._set.length) {
                Object entry = this._set[i];
                if (entry != null && this.REMOVED != entry) {
                    if (predicate.test(entry)) {
                        this.removeAt(i);
                    } else {
                        ++size;
                    }
                }
                ++i;
            }
        }
        finally {
            this.reenableAutoCompaction(false);
        }
        return size;
    }
}

