/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.ext;

import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THash;
import java.lang.reflect.Array;
import java.util.function.Consumer;

public abstract class HashBase<T>
extends THash {
    protected transient T[] _set;
    protected final T REMOVED;
    private final Class<T> clazz;

    public HashBase(Class<T> clazz, T REMOVED) {
        super(10, 0.75f);
        this.clazz = clazz;
        this.REMOVED = REMOVED;
        this.setUp(HashFunctions.fastCeil((float)13.333333f));
    }

    public HashBase(int initialCapacity, Class<T> clazz, T REMOVED) {
        super(initialCapacity, 0.75f);
        this.clazz = clazz;
        this.REMOVED = REMOVED;
        this.setUp(HashFunctions.fastCeil((float)((float)initialCapacity / 0.75f)));
    }

    public final int capacity() {
        return this._set.length;
    }

    protected final void removeAt(int index) {
        this._set[index] = this.REMOVED;
        super.removeAt(index);
    }

    protected final int setUp(int initialCapacity) {
        if (this.clazz == null) {
            return initialCapacity;
        }
        int capacity = super.setUp(initialCapacity);
        if (this.clazz != null) {
            this._set = this.createArray(capacity);
        }
        return capacity;
    }

    protected final T[] createArray(int capacity) {
        return (Object[])Array.newInstance(this.clazz, capacity);
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + String.valueOf(o1) + " object #1 hash = " + o1.hashCode() + " object #1 id = " + System.identityHashCode(o1) + "; object #2 =" + String.valueOf(o2) + " object #2 hash = " + o2.hashCode() + " object #2 id = " + System.identityHashCode(o2));
    }

    public final void values(Consumer<? super T> result) {
        int i = this._set.length;
        while (i-- > 0) {
            T entry = this._set[i];
            if (entry == null || entry == this.REMOVED) continue;
            result.accept(entry);
        }
    }
}

