/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.set.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeSet;
import java.util.function.Consumer;
import com.koloboke.collect.set.DoubleSetFactory;

import javax.annotation.Nonnull;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashDoubleSet}s.
 *
 * @see HashDoubleSet
 * @see HashDoubleSets#getDefaultFactory()
 * @see KolobokeSet @KolobokeSet
 */
public interface HashDoubleSetFactory
        extends DoubleSetFactory<HashDoubleSetFactory>
        , HashContainerFactory<HashDoubleSetFactory> {



    

    

    

    @Override
    @Nonnull
     HashDoubleSet newMutableSet();

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterable<Double> elements, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4,
            @Nonnull Iterable<Double> elems5, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterator<Double> elements, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull
            Consumer<com.koloboke.function.DoubleConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull double[] elements, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Double[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterable<Double> elements);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4,
            @Nonnull Iterable<Double> elems5);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Iterator<Double> elements);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull
            Consumer<com.koloboke.function.DoubleConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull double[] elements);

    @Override
    @Nonnull
     HashDoubleSet newMutableSet(@Nonnull Double[] elements);


    @Override
    @Nonnull
     HashDoubleSet newMutableSetOf(double e1);

    @Override
    @Nonnull
     HashDoubleSet newMutableSetOf(double e1, double e2);

    @Override
    @Nonnull
     HashDoubleSet newMutableSetOf(double e1, double e2,
            double e3);

    @Override
    @Nonnull
     HashDoubleSet newMutableSetOf(double e1, double e2,
            double e3, double e4);

    @Override
    @Nonnull
     HashDoubleSet newMutableSetOf(double e1, double e2,
            double e3, double e4, double e5,
            double... restElements);
    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet();

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterable<Double> elements, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4,
            @Nonnull Iterable<Double> elems5, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterator<Double> elements, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull
            Consumer<com.koloboke.function.DoubleConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull double[] elements, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Double[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterable<Double> elements);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4,
            @Nonnull Iterable<Double> elems5);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Iterator<Double> elements);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull
            Consumer<com.koloboke.function.DoubleConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull double[] elements);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSet(@Nonnull Double[] elements);


    @Override
    @Nonnull
     HashDoubleSet newUpdatableSetOf(double e1);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSetOf(double e1, double e2);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSetOf(double e1, double e2,
            double e3);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSetOf(double e1, double e2,
            double e3, double e4);

    @Override
    @Nonnull
     HashDoubleSet newUpdatableSetOf(double e1, double e2,
            double e3, double e4, double e5,
            double... restElements);

    

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterable<Double> elements, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4,
            @Nonnull Iterable<Double> elems5, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterator<Double> elements, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull
            Consumer<com.koloboke.function.DoubleConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull double[] elements, int expectedSize);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Double[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterable<Double> elements);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterable<Double> elems1,
            @Nonnull Iterable<Double> elems2,
            @Nonnull Iterable<Double> elems3,
            @Nonnull Iterable<Double> elems4,
            @Nonnull Iterable<Double> elems5);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Iterator<Double> elements);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull
            Consumer<com.koloboke.function.DoubleConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull double[] elements);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSet(@Nonnull Double[] elements);


    @Override
    @Nonnull
     HashDoubleSet newImmutableSetOf(double e1);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSetOf(double e1, double e2);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSetOf(double e1, double e2,
            double e3);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSetOf(double e1, double e2,
            double e3, double e4);

    @Override
    @Nonnull
     HashDoubleSet newImmutableSetOf(double e1, double e2,
            double e3, double e4, double e5,
            double... restElements);
}
