/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.utils;

import java.util.Arrays;

public class CompositeCharSequence
implements CharSequence {
    private CharSequence[] components;
    private int length;

    public CompositeCharSequence(CharSequence[] components) {
        this.components = components;
        this.length = Arrays.stream(components).mapToInt(CharSequence::length).sum();
    }

    public CharSequence[] getComponents() {
        return this.components;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        int off = 0;
        for (CharSequence component : this.components) {
            if (index >= (off += component.length())) continue;
            return component.charAt(index - off);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        StringBuilder sub = new StringBuilder();
        for (int idx = start; idx < end; ++idx) {
            sub.append(this.charAt(idx));
        }
        return sub;
    }
}

